/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.core;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.internal.IWEFigure;

public class ModelElementFigure
extends Figure
implements IWEFigure {
    private boolean alpha = false;

    public ModelElementFigure() {
        this.setOpaque(false);
        this.setForegroundColor(PreferenceReader.appearanceTextColor.get());
        this.setBackgroundColor(PreferenceReader.appearanceFillColor.get());
        this.setFont(PreferenceReader.appearanceDefaultFont.get());
        this.setMinimumSize(PreferenceReader.appearanceMinimumSize.get());
    }

    public void setAlpha(boolean alpha) {
        this.alpha = alpha;
    }

    public void setMinimumSize(Dimension d) {
        Dimension size = PreferenceReader.appearanceMinimumSize.get();
        if (d.width < size.width) {
            d.width = size.width;
        }
        if (d.height < size.height) {
            d.height = size.height;
        }
        super.setMinimumSize(d);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension minimum = this.getMinimumSize(wHint, hHint);
        return minimum;
    }

    public Dimension getPreferredChildrenSize(int wHint, int hHint) {
        Dimension pref = this.getMinimumSize(wHint, hHint).getCopy();
        if (this.getLayoutManager() != null) {
            pref.union(this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint));
        }
        return pref;
    }

    public IFigure getContentPane() {
        return this;
    }

    public void paint(Graphics graphics) {
        if (PreferenceReader.appearanceAntialiasing.get()) {
            graphics.setAntialias(1);
            graphics.setTextAntialias(1);
        }
        if (this.alpha) {
            graphics.setAlpha(130);
        }
        super.paint(graphics);
        if (PreferenceReader.appearanceShadowVisible.get()) {
            this.paintClientArea(graphics);
            this.paintFigure(graphics);
        }
    }

    public void setIcon(ImageDescriptor icon) {
    }

    public void setName(String name) {
    }

    public void setImageFactory(IImageFactory imageFactory) {
    }
}

