/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient45;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.HttpClientSslTrustManager;

public class HttpClientDefaultSSLSocketFactoryModifier {
    public static final String DEFAULT_SSL_PROTOCOL = "https.protocols";
    private SSLContext sslContext = null;
    private String defaultProtocolNames = System.getProperty("https.protocols");
    private static final String[] jreProtocols = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"};

    public synchronized SSLSocketFactory getSSLSocketFactory() throws IOException {
        if (this.sslContext == null) {
            try {
                this.sslContext = this.getSSLContext(this.defaultProtocolNames);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.sslContext == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslContext.getSocketFactory();
    }

    public synchronized SSLContext getSSLContext(String protocols) {
        SSLContext resultContext = null;
        if (protocols != null) {
            String[] httpsProtocols = protocols.split(",");
            int i = 0;
            while (i < httpsProtocols.length) {
                httpsProtocols[i] = httpsProtocols[i].trim();
                ++i;
            }
            List<String> splitProtocolsList = Arrays.asList(httpsProtocols);
            ArrayList<String> defaultProtocolsList = new ArrayList<String>();
            int i2 = 0;
            while (i2 < jreProtocols.length) {
                if (splitProtocolsList.contains(jreProtocols[i2])) {
                    defaultProtocolsList.add(jreProtocols[i2]);
                }
                ++i2;
            }
            for (String protocol : defaultProtocolsList) {
                try {
                    resultContext = SSLContext.getInstance(protocol);
                    resultContext.init(null, new TrustManager[]{new HttpClientSslTrustManager()}, null);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return resultContext;
    }
}

