/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.types;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.xtext.xbase.ide.types.ClasspathTypeDescriptor;
import org.eclipse.xtext.xbase.ide.types.ITypeDescriptor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ClasspathScanner {
    private static final Splitter PROPERTY_CLASSPATH_SPLITTER = Splitter.on((char)File.pathSeparatorChar);
    private static final Splitter MANIFEST_CLASSPATH_SPLITTER = Splitter.on((String)" ").omitEmptyStrings();
    private Cache<Pair<ClassLoader, Collection<String>>, Iterable<ITypeDescriptor>> classLoaderDescriptors;
    private Cache<Pair<URI, Collection<String>>, Iterable<ITypeDescriptor>> uriDescriptors;

    protected Cache<Pair<ClassLoader, Collection<String>>, Iterable<ITypeDescriptor>> createClassLoaderCache() {
        return CacheBuilder.newBuilder().initialCapacity(8).concurrencyLevel(2).maximumSize(32L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    protected Cache<Pair<URI, Collection<String>>, Iterable<ITypeDescriptor>> createUriCache() {
        return CacheBuilder.newBuilder().initialCapacity(64).concurrencyLevel(2).maximumSize(256L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ITypeDescriptor> getDescriptors(ClassLoader classLoader, Collection<String> packagePrefixes) {
        try {
            ClasspathScanner classpathScanner = this;
            synchronized (classpathScanner) {
                if (this.classLoaderDescriptors == null) {
                    this.classLoaderDescriptors = this.createClassLoaderCache();
                }
            }
            Pair _mappedTo = Pair.of((Object)classLoader, packagePrefixes);
            Callable<Iterable> _function = () -> this.loadDescriptors(classLoader, packagePrefixes);
            return (Iterable)this.classLoaderDescriptors.get((Object)_mappedTo, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ITypeDescriptor> getDescriptors(URI uri, Collection<String> packagePrefixes) {
        try {
            ClasspathScanner classpathScanner = this;
            synchronized (classpathScanner) {
                if (this.uriDescriptors == null) {
                    this.uriDescriptors = this.createUriCache();
                }
            }
            Pair _mappedTo = Pair.of((Object)uri, packagePrefixes);
            Callable<Iterable> _function = () -> this.loadDescriptors(uri, packagePrefixes);
            return (Iterable)this.uriDescriptors.get((Object)_mappedTo, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Iterable<ITypeDescriptor> getBootClasspathDescriptors(Collection<String> packagePrefixes) {
        Iterable _xblockexpression = null;
        String classpath = System.getProperty("sun.boot.class.path");
        if (classpath == null) {
            return Collections.emptyList();
        }
        Functions.Function1 _function = path -> this.getDescriptors(new File((String)path).toURI(), packagePrefixes);
        _xblockexpression = Iterables.concat((Iterable)IterableExtensions.map((Iterable)PROPERTY_CLASSPATH_SPLITTER.split((CharSequence)classpath), (Functions.Function1)_function));
        return _xblockexpression;
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(ClassLoader classLoader, Collection<String> packagePrefixes) {
        try {
            ClassLoader cl;
            Iterable _xblockexpression = null;
            LinkedList<ClassLoader> classLoaderHierarchy = new LinkedList<ClassLoader>();
            for (cl = classLoader; cl != null; cl = cl.getParent()) {
                classLoaderHierarchy.push(cl);
            }
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            while (!classLoaderHierarchy.isEmpty()) {
                URL[] _uRLs;
                cl = (ClassLoader)classLoaderHierarchy.pop();
                if (!(cl instanceof URLClassLoader)) continue;
                for (URL url : _uRLs = ((URLClassLoader)cl).getURLs()) {
                    uris.add(url.toURI());
                }
            }
            Functions.Function1 _function = it -> this.getDescriptors((URI)it, packagePrefixes);
            _xblockexpression = Iterables.concat((Iterable)IterableExtensions.map(uris, (Functions.Function1)_function));
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(URI uri, Collection<String> packagePrefixes) {
        String _scheme = uri.getScheme();
        boolean _equals = Objects.equal((Object)_scheme, (Object)"file");
        if (_equals) {
            File file = new File(uri);
            boolean _isDirectory = file.isDirectory();
            if (_isDirectory) {
                ArrayList<ITypeDescriptor> descriptors = new ArrayList<ITypeDescriptor>();
                this.loadDirectoryDescriptors(file, "", descriptors, packagePrefixes);
                return descriptors;
            }
            boolean _exists = file.exists();
            if (_exists) {
                return this.loadJarDescriptors(file, true, packagePrefixes);
            }
        }
        return Collections.emptyList();
    }

    protected void loadDirectoryDescriptors(File directory, String packageName, List<ITypeDescriptor> descriptors, Collection<String> packagePrefixes) {
        File[] children = directory.listFiles();
        if (children == null) {
            return;
        }
        for (File file : children) {
            boolean _isDirectory = file.isDirectory();
            if (_isDirectory) {
                String _xifexpression = null;
                boolean _isEmpty = packageName.isEmpty();
                if (_isEmpty) {
                    _xifexpression = file.getName();
                } else {
                    String _name = file.getName();
                    _xifexpression = packageName + "." + _name;
                }
                String subPackageName = _xifexpression;
                this.loadDirectoryDescriptors(file, subPackageName, descriptors, packagePrefixes);
                continue;
            }
            ClasspathTypeDescriptor typeDesc = ClasspathTypeDescriptor.forFile(file, packageName, packagePrefixes);
            if (typeDesc == null) continue;
            descriptors.add(typeDesc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Iterable<ITypeDescriptor> loadJarDescriptors(File file, boolean includeManifestEntries, Collection<String> packagePrefixes) {
        try (ZipFile jarFile = null;){
            Iterable<ITypeDescriptor> iterable;
            String classpath;
            JarFile _jarFile = new JarFile(file, false);
            jarFile = _jarFile;
            ArrayList<Iterable<ITypeDescriptor>> descriptorCollections = null;
            if (includeManifestEntries && ((JarFile)jarFile).getManifest() != null && (classpath = ((JarFile)jarFile).getManifest().getMainAttributes().getValue("Class-Path")) != null) {
                ArrayList<Iterable<ITypeDescriptor>> _arrayList;
                descriptorCollections = _arrayList = new ArrayList<Iterable<ITypeDescriptor>>();
                Iterable _split = MANIFEST_CLASSPATH_SPLITTER.split((CharSequence)classpath);
                for (String path : _split) {
                    try {
                        boolean _not;
                        URI uri = new URI(path);
                        boolean _isAbsolute = uri.isAbsolute();
                        boolean bl = _not = !_isAbsolute;
                        if (_not) {
                            File _parentFile = file.getParentFile();
                            String _replace = path.replace("/", File.separator);
                            uri = new File(_parentFile, _replace).toURI();
                        }
                        Iterable<ITypeDescriptor> _descriptors = this.getDescriptors(uri, packagePrefixes);
                        descriptorCollections.add(_descriptors);
                    }
                    catch (Throwable _t) {
                        if (!(_t instanceof URISyntaxException)) throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            ArrayList<ITypeDescriptor> descriptors = new ArrayList<ITypeDescriptor>();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                ClasspathTypeDescriptor typeDesc;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().startsWith("META-INF") || (typeDesc = ClasspathTypeDescriptor.forJarEntry(entry, (JarFile)jarFile, packagePrefixes)) == null) continue;
                descriptors.add(typeDesc);
            }
            if (descriptorCollections == null) {
                iterable = descriptors;
                return iterable;
            }
            descriptorCollections.add(descriptors);
            iterable = Iterables.concat(descriptorCollections);
            return iterable;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

