/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.internal.JsonException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonUtil {
    private static final Logger LOGGER = Logger.getLogger(JsonUtil.class.getName());

    public static String streamAwareToJson(JSONStreamAware object) {
        StringWriter out = new StringWriter();
        try {
            object.writeJSONString((Writer)out);
        }
        catch (IOException iOException) {
            return null;
        }
        return out.toString();
    }

    public static JSONObject jsonObjectFromJson(String json) throws ParseException {
        JSONParser p = new JSONParser();
        Object parsed = p.parse(json);
        if (!(parsed instanceof JSONObject)) {
            LOGGER.log(Level.SEVERE, "Not a JSON object: {0}", json);
            return null;
        }
        return (JSONObject)parsed;
    }

    public static Long getAsLong(JSONObject obj, CharSequence key) {
        String keyString = key.toString();
        Object v = obj.get((Object)keyString);
        if (v instanceof Long || v == null) {
            return (Long)v;
        }
        LOGGER.log(Level.SEVERE, "Key: {0}, found value: {1}", new Object[]{keyString, v});
        return null;
    }

    public static Double getAsDouble(JSONObject obj, CharSequence key) {
        String keyString = key.toString();
        Object v = obj.get((Object)keyString);
        if (v instanceof Double || v == null) {
            return (Double)v;
        }
        LOGGER.log(Level.SEVERE, "Key: {0}, found value: {1}", new Object[]{keyString, v});
        return null;
    }

    public static String getAsString(JSONObject obj, CharSequence key) {
        String keyString = key.toString();
        Object v = obj.get((Object)keyString);
        if (v instanceof String || v == null) {
            return (String)v;
        }
        return String.valueOf(v);
    }

    public static Boolean getAsBoolean(JSONObject obj, CharSequence key) {
        String keyString = key.toString();
        Object v = obj.get((Object)keyString);
        if (v instanceof Boolean || v == null) {
            return v != null ? (Boolean)v : false;
        }
        LOGGER.log(Level.SEVERE, "Key: {0}, found value: {1}", new Object[]{keyString, v});
        return false;
    }

    public static JSONObject getAsJSON(JSONObject obj, CharSequence key) {
        String keyString = key.toString();
        Object v = obj.get((Object)keyString);
        if (v instanceof JSONObject || v == null) {
            return (JSONObject)v;
        }
        LOGGER.log(Level.SEVERE, "Key: {0}, found value: {1}", new Object[]{keyString, v});
        return null;
    }

    public static JSONObject getAsJSONStrict(JSONObject obj, CharSequence key) {
        JSONObject result = JsonUtil.getAsJSON(obj, key);
        if (result == null) {
            throw new JsonException("Failed to find property '" + key);
        }
        return result;
    }

    public static JSONArray getAsJSONArray(JSONObject obj, CharSequence key) {
        String keyString = key.toString();
        Object v = obj.get((Object)keyString);
        if (v instanceof JSONArray || v == null) {
            return (JSONArray)v;
        }
        LOGGER.log(Level.SEVERE, "Key: {0}, found value: {1}", new Object[]{keyString, v});
        return null;
    }

    public static JSONArray getAsJSONArrayStrict(JSONObject obj, CharSequence key) {
        JSONArray result = JsonUtil.getAsJSONArray(obj, key);
        if (result == null) {
            throw new JsonException("Failed to find property '" + key + "' of array type");
        }
        return result;
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String quoteString(String string) {
        return "\"" + string + "\"";
    }

    private JsonUtil() {
    }
}

