/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class HasLanguageConfigurationPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IContentType[] contentTypes;
        if (!(receiver instanceof ITextEditor)) {
            return false;
        }
        ITextEditor editor = (ITextEditor)receiver;
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider docProvider = editor.getDocumentProvider();
        if (docProvider == null || input == null) {
            return false;
        }
        IDocument document = docProvider.getDocument((Object)input);
        if (document == null) {
            return false;
        }
        try {
            contentTypes = ContentTypeHelper.findContentTypes((IDocument)document).getContentTypes();
        }
        catch (CoreException coreException) {
            return false;
        }
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        return registry.getLanguageConfigurationFor(contentTypes) != null;
    }
}

