/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openshmem.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.analysis.PldtAstVisitor;
import org.eclipse.ptp.pldt.openshmem.Activator;
import org.eclipse.ptp.pldt.openshmem.OpenSHMEMIDs;
import org.eclipse.ptp.pldt.openshmem.messages.Messages;

public class OpenSHMEMCASTVisitor
extends PldtAstVisitor {
    private static final String PREFIX = "shmem_";

    public OpenSHMEMCASTVisitor(List<String> includes, String fileName, boolean allowPrefixOnlyMatch, ScanReturn msr) {
        super(includes, fileName, allowPrefixOnlyMatch, msr);
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        ARTIFACT_CALL = Messages.OpenSHMEMCASTVisitor_openshmem_call;
        ARTIFACT_CONSTANT = Messages.OpenSHMEMCASTVisitor_openshmem_constant;
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            if (signature.startsWith(PREFIX) && astExpr instanceof IASTIdExpression) {
                IASTName funcName = ((IASTIdExpression)astExpr).getName();
                this.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof IASTLiteralExpression) {
            this.processMacroLiteral((IASTLiteralExpression)expression);
        }
        return 3;
    }

    protected String getIncludesPrefID() {
        return OpenSHMEMIDs.OpenSHMEM_INCLUDES;
    }

    protected IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public boolean matchesPrefix(String name) {
        return name.startsWith(PREFIX);
    }
}

