/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.Activator;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.swt.graphics.Image;

public class DynamicNavigateLabelProvider {
    protected static boolean isLocalLabelProvider;

    public static String getText(Object element) {
        if (element instanceof NavigableElement) {
            return ((NavigableElement)element).getLabel();
        }
        if (element instanceof EObject) {
            return DynamicNavigateLabelProvider.getName((EObject)element);
        }
        return element.toString();
    }

    public static Image getImage(Object element) {
        ILabelProvider labelProvider;
        if (element instanceof EObject && (labelProvider = DynamicNavigateLabelProvider.getLabelProvider((EObject)element)) != null) {
            Image icon = null;
            icon = labelProvider.getImage(element);
            if (isLocalLabelProvider) {
                labelProvider.dispose();
            }
            return icon;
        }
        return null;
    }

    public static String getToolTipText(Object element) {
        if (element instanceof EObject) {
            return DynamicNavigateLabelProvider.getName((EObject)element);
        }
        return element.toString();
    }

    protected static ILabelProvider getLabelProvider(EObject element) {
        ILabelProvider labelProvider = null;
        try {
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)element)).getLabelProvider("org.eclipse.papyrus.infra.services.navigation.menu.labelprovider");
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (labelProvider == null) {
            labelProvider = new LabelProvider();
            isLocalLabelProvider = true;
        } else {
            isLocalLabelProvider = false;
        }
        return labelProvider;
    }

    protected static String getName(EObject element) {
        ILabelProvider labelProvider = DynamicNavigateLabelProvider.getLabelProvider(element);
        String name = labelProvider.getText((Object)element);
        if (isLocalLabelProvider) {
            labelProvider.dispose();
        }
        if (name != null) {
            return name;
        }
        return element.toString();
    }
}

