/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;

public class PlatformURIHandlerImpl
extends URIHandlerImpl {
    private static final @NonNull PlatformURIHandlerImpl INSTANCE = new PlatformURIHandlerImpl();
    private static final @NonNull FileURIHandlerImpl fileHandler = new FileURIHandlerImpl();
    private static final @NonNull PlatformResourceURIHandlerImpl resourceHandler = new PlatformResourceURIHandlerImpl();

    public static void install(@NonNull URIConverter uriConverter) {
        EList uriHandlers = uriConverter.getURIHandlers();
        uriHandlers.add(0, INSTANCE);
    }

    protected PlatformURIHandlerImpl() {
        assert (EMFPlugin.IS_ECLIPSE_RUNNING);
    }

    public boolean canHandle(URI uri) {
        return uri.isPlatform();
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI resourceURI = this.getResourceURI(uri);
        if (resourceURI != null) {
            return resourceHandler.contentDescription(resourceURI, options);
        }
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.contentDescription(fileURI, options);
        }
        return super.contentDescription(this.getPluginURI(uri), options);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI resourceURI = this.getResourceURI(uri);
        if (resourceURI != null) {
            return resourceHandler.createInputStream(resourceURI, options);
        }
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.createInputStream(fileURI, options);
        }
        return super.createInputStream(this.getPluginURI(uri), options);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI resourceURI = this.getResourceURI(uri);
        if (resourceURI != null) {
            return resourceHandler.createOutputStream(resourceURI, options);
        }
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.createOutputStream(fileURI, options);
        }
        return super.createOutputStream(this.getPluginURI(uri), options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI resourceURI = this.getResourceURI(uri);
        if (resourceURI != null) {
            resourceHandler.delete(resourceURI, options);
            return;
        }
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            fileHandler.delete(fileURI, options);
            return;
        }
        super.delete(this.getPluginURI(uri), options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        assert (uri != null);
        URI resourceURI = this.getResourceURI(uri);
        if (resourceURI != null) {
            return resourceHandler.exists(resourceURI, options);
        }
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.exists(fileURI, options);
        }
        return super.exists(this.getPluginURI(uri), options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        assert (uri != null);
        URI resourceURI = this.getResourceURI(uri);
        if (resourceURI != null) {
            return resourceHandler.getAttributes(resourceURI, options);
        }
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.getAttributes(fileURI, options);
        }
        return super.getAttributes(this.getPluginURI(uri), options);
    }

    protected @Nullable URI getFileURI(@NonNull URI uri) {
        String bundleName = uri.segment(1);
        Bundle bundle = Platform.getBundle((String)bundleName);
        String location = bundle.getLocation();
        URI locationURI = URI.createURI((String)location);
        if (locationURI.hasOpaquePart()) {
            locationURI = URI.createURI((String)locationURI.opaquePart());
        }
        if (!locationURI.isFile()) {
            return null;
        }
        if (locationURI.hasTrailingPathSeparator()) {
            locationURI = locationURI.trimSegments(1);
        }
        int i = 2;
        while (i < uri.segmentCount()) {
            locationURI = locationURI.appendSegment(uri.segment(i));
            ++i;
        }
        return locationURI;
    }

    protected @NonNull URI getPluginURI(@NonNull URI uri) {
        if (uri.isPlatformPlugin()) {
            return uri;
        }
        return URI.createPlatformPluginURI((String)uri.toPlatformString(false), (boolean)false);
    }

    protected @Nullable URI getResourceURI(@NonNull URI uri) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource project = workspaceRoot.findMember(uri.segment(1));
        if (project == null) {
            return null;
        }
        if (uri.isPlatformResource()) {
            return uri;
        }
        return URI.createPlatformResourceURI((String)uri.toPlatformString(false), (boolean)false);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI resourceURI = this.getResourceURI(uri);
        if (resourceURI != null) {
            resourceHandler.setAttributes(resourceURI, attributes, options);
            return;
        }
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            fileHandler.setAttributes(fileURI, attributes, options);
            return;
        }
        super.setAttributes(this.getPluginURI(uri), attributes, options);
    }
}

