/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.as2es;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.PivotPlugin;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.Unlimited;

public class AS2EcoreTypeRefVisitor
extends AbstractExtendingVisitor<EObject, AS2Ecore> {
    private static final Logger logger = Logger.getLogger(AS2EcoreTypeRefVisitor.class);
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    protected final boolean isRequired;
    private EPackage oclstdlibEPackage;
    private @Nullable EClassifier oclAnyEClass;
    private @Nullable EClassifier oclInvalidEClass;
    private @Nullable EClassifier oclVoidEClass;

    @Deprecated
    public AS2EcoreTypeRefVisitor(@NonNull AS2Ecore context) {
        this(context, true);
    }

    public AS2EcoreTypeRefVisitor(@NonNull AS2Ecore context, boolean isRequired) {
        super(context);
        this.metamodelManager = context.getMetamodelManager();
        this.standardLibrary = context.getStandardLibrary();
        this.isRequired = isRequired;
    }

    private @Nullable EClassifier getOclStdlibEClassifier(String className) {
        if (this.oclstdlibEPackage == null) {
            URI oclstdlibURI = null;
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                    oclstdlibURI = URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/oclstdlib.ecore", (boolean)true);
                    resourceSet.getURIConverter().getURIMap().put(URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot", (boolean)true), URI.createURI((String)PivotPlugin.INSTANCE.getBaseURL().toString()));
                } else {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.ocl.pivot");
                    oclstdlibURI = project != null && project.exists() ? URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/oclstdlib.ecore", (boolean)true) : URI.createPlatformPluginURI((String)"org.eclipse.ocl.pivot/model-gen/oclstdlib.ecore", (boolean)true);
                }
                Resource resource = resourceSet.getResource(oclstdlibURI, true);
                this.oclstdlibEPackage = (EPackage)resource.getContents().get(0);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to load '" + oclstdlibURI + "'"), (Throwable)e);
                this.oclstdlibEPackage = OCLstdlibPackage.eINSTANCE;
            }
        }
        return this.oclstdlibEPackage.getEClassifier(className);
    }

    public EGenericType resolveEGenericType(@NonNull Class type) {
        EObject eType = this.safeVisit(type);
        if (eType instanceof EGenericType) {
            return (EGenericType)eType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)eType);
        TemplateSignature templateSignature = type.getOwnedSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : PivotUtil.getOwnedParameters(templateSignature)) {
                EObject eTypeParameter = this.safeVisit(templateParameter);
                if (!(eTypeParameter instanceof EGenericType)) continue;
                eGenericType.getETypeArguments().add((Object)((EGenericType)eTypeParameter));
            }
        }
        return eGenericType;
    }

    @Override
    public EObject safeVisit(@Nullable Visitable v) {
        if (v instanceof Type) {
            v = this.metamodelManager.getPrimaryType((Type)v);
        }
        return v == null ? null : v.accept(this);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EClassifier visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for AS2Ecore TypeRef pass");
    }

    @Override
    public EObject visitAnyType(@NonNull AnyType pivotType) {
        EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        if (this.oclAnyEClass == null) {
            this.oclAnyEClass = this.getOclStdlibEClassifier(OCLstdlibPackage.Literals.OCL_ANY.getName());
        }
        return this.oclAnyEClass;
    }

    @Override
    public EObject visitClass(@NonNull Class pivotType) {
        if (pivotType.getOwnedBindings().size() == 0) {
            EObject eTarget;
            EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
            if (eClassifier != null) {
                return eClassifier;
            }
            if (this.metamodelManager.isTypeServeable(pivotType)) {
                Iterable<Class> partialClasses = this.metamodelManager.getPartialClasses(pivotType);
                for (Class type : partialClasses) {
                    EObject eTarget2;
                    if (!(type instanceof PivotObjectImpl) || (eTarget2 = ((PivotObjectImpl)((Object)type)).getESObject()) == null) continue;
                    return eTarget2;
                }
            } else if (pivotType instanceof PivotObjectImpl && (eTarget = ((PivotObjectImpl)((Object)pivotType)).getESObject()) != null) {
                return eTarget;
            }
            return null;
        }
        List<TemplateBinding> templateBindings = pivotType.getOwnedBindings();
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EObject rawType = this.safeVisit(PivotUtil.getUnspecializedTemplateableElement(pivotType));
        eGenericType.setEClassifier((EClassifier)rawType);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)templateBindings.get(0).getOwnedSubstitutions());
        return eGenericType;
    }

    @Override
    public EObject visitCollectionType(@NonNull CollectionType pivotType) {
        if (pivotType.getOwnedBindings().size() == 0) {
            EClassifier eClassifier1 = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
            if (eClassifier1 != null) {
                return eClassifier1;
            }
            Iterable<Class> partialClasses = this.metamodelManager.getPartialClasses(pivotType);
            for (Class type : partialClasses) {
                EObject eTarget;
                if (!(type instanceof PivotObjectImpl) || (eTarget = ((PivotObjectImpl)((Object)type)).getESObject()) == null) continue;
                return eTarget;
            }
            return this.getOclStdlibEClassifier(pivotType.getName());
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EObject eClassifier2 = this.safeVisit(PivotUtil.getUnspecializedTemplateableElement(pivotType));
        eGenericType.setEClassifier((EClassifier)eClassifier2);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)pivotType.getOwnedBindings().get(0)).getOwnedSubstitutions());
        Number lower = pivotType.getLower();
        Number upper = pivotType.getUpper();
        if (lower != null && upper != null && lower.longValue() == 0L) {
            boolean cfr_ignored_0 = upper instanceof Unlimited;
        }
        return eGenericType;
    }

    @Override
    public EObject visitInvalidType(@NonNull InvalidType pivotType) {
        EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        if (this.oclInvalidEClass == null) {
            this.oclInvalidEClass = this.getOclStdlibEClassifier(OCLstdlibPackage.Literals.OCL_INVALID.getName());
        }
        return this.oclInvalidEClass;
    }

    @Override
    public EObject visitMapType(@NonNull MapType object) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EClassifier eClassifier = this.getOclStdlibEClassifier(object.getName());
        eGenericType.setEClassifier(eClassifier);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)object.getOwnedBindings().get(0)).getOwnedSubstitutions());
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)object.getOwnedBindings().get(1)).getOwnedSubstitutions());
        return eGenericType;
    }

    @Override
    public EObject visitPrimitiveType(@NonNull PrimitiveType pivotType) {
        EDataType eClassifier = ((AS2Ecore)this.context).getCreated(EDataType.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        String uri = ((AS2Ecore)this.context).getPrimitiveTypesUriPrefix();
        if (uri != null) {
            URI proxyURI = URI.createURI((String)(String.valueOf(uri) + pivotType.getName()));
            eClassifier = EcoreFactory.eINSTANCE.createEDataType();
            ((InternalEObject)eClassifier).eSetProxyURI(proxyURI);
            ((AS2Ecore)this.context).putCreated(pivotType, (EModelElement)eClassifier);
            return eClassifier;
        }
        CompleteClassInternal completeClass = this.metamodelManager.getCompleteClass(pivotType);
        List<Class> partialClasses = completeClass.getPartialClasses();
        for (Class aType : partialClasses) {
            if (aType instanceof PrimitiveType || (eClassifier = ((AS2Ecore)this.context).getCreated(EDataType.class, pivotType)) == null) continue;
            return eClassifier;
        }
        Package standardLibraryPackage = this.standardLibrary.getPackage();
        for (Class aType : partialClasses) {
            Package pivotPackage = aType.getOwningPackage();
            if (pivotPackage != standardLibraryPackage) continue;
            if (aType == this.standardLibrary.getStringType()) {
                return EcorePackage.Literals.ESTRING;
            }
            if (aType == this.standardLibrary.getBooleanType()) {
                return this.isRequired ? EcorePackage.Literals.EBOOLEAN : EcorePackage.Literals.EBOOLEAN_OBJECT;
            }
            if (aType == this.standardLibrary.getIntegerType()) {
                return EcorePackage.Literals.EBIG_INTEGER;
            }
            if (aType == this.standardLibrary.getRealType()) {
                return EcorePackage.Literals.EBIG_DECIMAL;
            }
            if (aType != this.standardLibrary.getUnlimitedNaturalType()) continue;
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        throw new IllegalArgumentException("Unsupported primitive type '" + pivotType + "' in AS2Ecore TypeRef pass");
    }

    @Override
    public EObject visitTemplateBinding(@NonNull TemplateBinding object) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        return eGenericType;
    }

    @Override
    public EObject visitTemplateParameter(@NonNull TemplateParameter pivotType) {
        ETypeParameter eTypeParameter = ((AS2Ecore)this.context).getCreated(ETypeParameter.class, pivotType);
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setETypeParameter(eTypeParameter);
        return eGenericType;
    }

    @Override
    public EObject visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution pivotTemplateParameterSubstitution) {
        EObject actualType = this.safeVisit(pivotTemplateParameterSubstitution.getActual());
        if (actualType instanceof EGenericType) {
            return actualType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)actualType);
        return eGenericType;
    }

    @Override
    public EObject visitVoidType(@NonNull VoidType pivotType) {
        EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        if (this.oclVoidEClass == null) {
            this.oclVoidEClass = this.getOclStdlibEClassifier(OCLstdlibPackage.Literals.OCL_VOID.getName());
        }
        return this.oclVoidEClass;
    }
}

