/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.alm.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet
extends HttpServlet {
    static final Logger LOG = LoggerFactory.getLogger(Servlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.handleDashboardRequestParameter(req.getParameterMap());
        try {
            PrintWriter writer = resp.getWriter();
            writer.write(NLS.bind((String)Messages.ServletResponseText, (Object)System.getProperty("user.name")));
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage());
        }
    }

    private void handleDashboardRequestParameter(Map<String, String[]> parameterMap) {
        String[] summaryIdParameter = parameterMap.get("summaryId");
        String[] resultNodeParameter = parameterMap.get("resultNode");
        Long nodeCount = 1L;
        if (resultNodeParameter != null) {
            try {
                nodeCount = Long.valueOf(resultNodeParameter[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (summaryIdParameter != null) {
            try {
                Long summaryId = Long.valueOf(summaryIdParameter[0]);
                this.openTestResultDetailAndSelectNode(summaryId, nodeCount);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void openTestResultDetailAndSelectNode(Long summaryId, Long nodeCount) {
        new OpenTestResultDetailsJob(NLS.bind((String)Messages.OpeningTestResultDetailsJobName, (Object)summaryId), summaryId, nodeCount).schedule(1000L);
    }

    private static class OpenTestResultDetailsJob
    extends UIJob {
        private Long m_summaryId;
        private Long m_nodeCount;

        public OpenTestResultDetailsJob(String name, Long summaryId, Long nodeCount) {
            super(name);
            this.m_summaryId = summaryId;
            this.m_nodeCount = nodeCount;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Command projectPropertiesCommand = CommandHelper.getCommandService().getCommand("org.eclipse.jubula.client.ui.commands.OpenTestResultViewer");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.eclipse.jubula.client.ui.commands.OpenTestResultViewer.parameter.summaryId", this.m_summaryId.toString());
            parameters.put("org.eclipse.jubula.client.ui.commands.OpenTestResultViewer.parameter.resultNode", this.m_nodeCount.toString());
            CommandHelper.executeParameterizedCommand((ParameterizedCommand)ParameterizedCommand.generateCommand((Command)projectPropertiesCommand, parameters));
            return Status.OK_STATUS;
        }
    }
}

