/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.REMByteTypeBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMPrimitiveBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMByteTypeBeanTypeProxy
extends REMPrimitiveBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;
    private final INumberBeanProxy oneProxy;
    private final INumberBeanProxy twoProxy;
    private final INumberBeanProxy threeProxy;

    REMByteTypeBeanTypeProxy(REMProxyFactoryRegistry aRegistry) {
        super(aRegistry, new Integer(5), Byte.TYPE.getName());
        this.zeroProxy = new REMByteTypeBeanProxy(aRegistry, 0);
        this.oneProxy = new REMByteTypeBeanProxy(aRegistry, 1);
        this.twoProxy = new REMByteTypeBeanProxy(aRegistry, 2);
        this.threeProxy = new REMByteTypeBeanProxy(aRegistry, 3);
    }

    INumberBeanProxy createByteBeanProxy(byte aByte) {
        switch (aByte) {
            case 0: {
                return this.zeroProxy;
            }
            case 1: {
                return this.oneProxy;
            }
            case 2: {
                return this.twoProxy;
            }
            case 3: {
                return this.threeProxy;
            }
        }
        return new REMByteTypeBeanProxy(this.fRegistry, aByte);
    }

    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createByteBeanProxy(value.aByte);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        byte aByte;
        String trim = initializationString.trim();
        if (trim.length() == 0) {
            return super.newInstance(initializationString);
        }
        if (trim.startsWith("(byte)")) {
            Number v = REMByteTypeBeanTypeProxy.parseString(trim.substring("(byte)".length()).trim());
            if (v == null) return super.newInstance(initializationString);
            aByte = v.byteValue();
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aByte);
        }
        try {
            aByte = Byte.decode(trim);
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(aByte);
        }
        catch (NumberFormatException numberFormatException) {
            return super.newInstance(initializationString);
        }
    }
}

