/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.macbundler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.macbundler.BundleAttributes;
import org.eclipse.jdt.internal.ui.macbundler.MacOSXUILaunchingPlugin;
import org.eclipse.jdt.internal.ui.macbundler.ResourceInfo;
import org.eclipse.jdt.internal.ui.macbundler.Util;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

class BundleDescription
implements BundleAttributes {
    private static final String STUB = "/System/Library/Frameworks/JavaVM.framework/Versions/A/Resources/MacOS/JavaApplicationStub";
    private static final String ICON = "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Resources/GenericApp.icns";
    private static Set<String> RUN_MODE;
    private ListenerList<IPropertyChangeListener> fListeners;
    private Properties fProperties;
    private List<ResourceInfo> fClassPath;
    private List<ResourceInfo> fResources;
    Properties fProperties2;

    BundleDescription() {
        RUN_MODE = new HashSet<String>();
        RUN_MODE.add("run");
        this.fListeners = new ListenerList();
        this.fProperties = new Properties();
        this.fClassPath = new ArrayList<ResourceInfo>();
        this.fResources = new ArrayList<ResourceInfo>();
        this.fProperties2 = new Properties();
        this.clear();
    }

    void clear() {
        this.fProperties.clear();
        this.fClassPath.clear();
        this.fResources.clear();
        this.fProperties2.clear();
        this.fProperties.put("Signature", "????");
        this.fProperties.put("IconFile", ICON);
    }

    void addResource(ResourceInfo ri, boolean onClasspath) {
        if (onClasspath) {
            this.fClassPath.add(ri);
        } else {
            this.fResources.add(ri);
        }
    }

    boolean removeResource(ResourceInfo ri, boolean onClasspath) {
        if (onClasspath) {
            return this.fClassPath.remove(ri);
        }
        return this.fResources.remove(ri);
    }

    ResourceInfo[] getResources(boolean onClasspath) {
        if (onClasspath) {
            return this.fClassPath.toArray(new ResourceInfo[this.fClassPath.size()]);
        }
        return this.fResources.toArray(new ResourceInfo[this.fResources.size()]);
    }

    void addListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    void removeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    String get(String key) {
        return this.fProperties.getProperty(key);
    }

    public String get(String key, String dflt) {
        return this.fProperties.getProperty(key, dflt);
    }

    public boolean get(String key, boolean dflt) {
        Boolean v = (Boolean)this.fProperties.get(key);
        if (v == null) {
            return dflt;
        }
        return v;
    }

    void setValue(String key, Object value) {
        this.fProperties.put(key, value);
    }

    private static AbstractJavaLaunchConfigurationDelegate getDelegate(ILaunchConfiguration lc) throws CoreException {
        ILaunchDelegate[] delegates = lc.getType().getDelegates(RUN_MODE);
        int i = 0;
        while (i < delegates.length) {
            if (delegates[i].getDelegate() instanceof AbstractJavaLaunchConfigurationDelegate) {
                return (AbstractJavaLaunchConfigurationDelegate)delegates[i].getDelegate();
            }
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, MacOSXUILaunchingPlugin.getUniqueIdentifier(), "Internal Error: missing Java launcher"));
    }

    void inititialize(ILaunchConfiguration lc) {
        AbstractJavaLaunchConfigurationDelegate lcd;
        try {
            lcd = BundleDescription.getDelegate(lc);
        }
        catch (CoreException coreException) {
            return;
        }
        String appName = lc.getName();
        this.fProperties.put("AppName", appName);
        this.fProperties.put("GetInfo", String.valueOf(appName) + Util.getString("BundleDescription.copyright.format"));
        try {
            this.fProperties.put("MainClass", lcd.getMainTypeName(lc));
        }
        catch (CoreException coreException) {
            this.fProperties.put("MainClass", "");
        }
        try {
            this.fProperties.put("Arguments", lcd.getProgramArguments(lc));
        }
        catch (CoreException coreException) {
            this.fProperties.put("Arguments", "");
        }
        String wd = null;
        try {
            wd = lcd.getWorkingDirectory(lc).getAbsolutePath();
        }
        catch (CoreException coreException) {}
        try {
            this.fProperties.put("MainClass", lcd.getMainTypeName(lc));
        }
        catch (CoreException coreException) {
            this.fProperties.put("MainClass", "");
        }
        try {
            String[] classpath = lcd.getClasspath(lc);
            int i = 0;
            while (i < classpath.length) {
                this.addResource(new ResourceInfo(classpath[i]), true);
                ++i;
            }
        }
        catch (CoreException coreException) {}
        String vmOptions2 = "";
        String vmOptions = null;
        try {
            vmOptions = lcd.getVMArguments(lc);
        }
        catch (CoreException coreException) {}
        if (vmOptions != null) {
            StringTokenizer st = new StringTokenizer(vmOptions);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int pos = token.indexOf(61);
                if (pos > 2 && token.startsWith("-D")) {
                    String key = token.substring(2, pos).trim();
                    String value = token.substring(pos + 1).trim();
                    int l = value.length();
                    if (l >= 2 && value.charAt(0) == '\"' && value.charAt(l - 1) == '\"') {
                        value = value.substring(1, l - 1);
                    }
                    if ("java.library.path".equals(key)) {
                        this.addDllDir(wd, value);
                        continue;
                    }
                    this.fProperties2.put(key, value);
                    continue;
                }
                vmOptions2 = String.valueOf(vmOptions2) + token + ' ';
            }
        }
        this.fProperties.put("VMOptions", vmOptions2);
        boolean isSWT = false;
        for (ResourceInfo ri : this.fResources) {
            if (ri.fPath.indexOf("libswt-carbon") < 0) continue;
            isSWT = true;
            break;
        }
        this.fProperties.put("UsesSWT", (Object)isSWT);
        String launcher = null;
        if (isSWT) {
            launcher = System.getProperty("org.eclipse.swtlauncher");
        }
        if (launcher == null) {
            this.setValue("JVMVersion", "1.4*");
            launcher = STUB;
        }
        this.setValue("CFBundleExecutable", launcher);
        IJavaProject p = null;
        try {
            p = lcd.getJavaProject(lc);
        }
        catch (CoreException coreException) {}
        if (p != null) {
            this.fProperties.put("Identifier", p.getElementName());
        } else {
            this.fProperties.put("Identifier", "");
        }
        this.fireChange();
    }

    void fireChange() {
        PropertyChangeEvent e = new PropertyChangeEvent((Object)this, "ALL", null, null);
        for (IPropertyChangeListener listener : this.fListeners) {
            listener.propertyChange(e);
        }
    }

    private void addDllDir(String wd, String path) {
        File lib_dir = path.startsWith("../") ? new File(wd, path) : new File(path);
        if (lib_dir.isDirectory()) {
            File[] dlls = lib_dir.listFiles();
            int j = 0;
            while (j < dlls.length) {
                try {
                    String name = dlls[j].getCanonicalPath();
                    if (name.endsWith(".jnilib")) {
                        this.addResource(new ResourceInfo(name), false);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
    }

    static boolean verify(ILaunchConfiguration lc) {
        String name = lc.getName();
        if (name.indexOf("jpage") >= 0) {
            return false;
        }
        try {
            AbstractJavaLaunchConfigurationDelegate lcd = BundleDescription.getDelegate(lc);
            return lcd.getMainTypeName(lc) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    static boolean matches(ILaunchConfiguration lc, IJavaProject project) {
        AbstractJavaLaunchConfigurationDelegate lcd;
        try {
            lcd = BundleDescription.getDelegate(lc);
        }
        catch (CoreException coreException) {
            return false;
        }
        IJavaProject p = null;
        try {
            p = lcd.getJavaProject(lc);
        }
        catch (CoreException coreException) {
            return false;
        }
        return project != null && project.equals(p);
    }
}

