/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ip.dscagent;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Dictionary;
import org.eclipse.equinox.internal.ip.impl.Log;
import org.eclipse.equinox.internal.ip.impl.ProvisioningAgent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DiscoveryAgent
implements Runnable {
    public static final String HTTP_PORT = "equinox.provisioning.gwhttp.port";
    public static final String HTTPS_PORT = "equinox.provisioning.gwhttps.port";
    public static final String TIMEOUT = "equinox.provisioning.packet.timeout";
    public static final char SEPARATOR = '#';
    public static final String NULL = new String(new byte[]{1});
    private ProvisioningAgent prvAgent;
    private boolean active = true;
    private MulticastSocket mcsocket;
    private InetAddress group;
    private BundleContext bc;

    public DiscoveryAgent(String address, int port, BundleContext bc, ProvisioningAgent prvAgent) throws UnknownHostException, IOException {
        this.group = InetAddress.getByName(address);
        this.mcsocket = new MulticastSocket(port);
        this.bc = bc;
        this.prvAgent = prvAgent;
        this.mcsocket.joinGroup(this.group);
        this.mcsocket.setSoTimeout(ProvisioningAgent.getInteger(TIMEOUT, 10000));
        Log.debug("Discovery Agent has joined to multicast socket " + address + ":" + port + ".");
    }

    public void run() {
        byte[] buffer = new byte[256];
        DatagramPacket request = new DatagramPacket(buffer, buffer.length);
        Log.debug("Discovery Agent starting listening.");
        int errors = 0;
        while (this.active) {
            try {
                byte[] data;
                this.mcsocket.receive(request);
                if ("equinox.provisioning.ping".equals(new String(request.getData(), 0, request.getLength())) && (data = this.getResponse()) != null) {
                    DatagramPacket response = new DatagramPacket(data, data.length, this.group, request.getPort());
                    this.mcsocket.send(response);
                }
                request.setLength(buffer.length);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException e) {
                if (errors++ <= 5) continue;
                Log.debug("Seventh unexpected exception. Discoverer will be closed!", e);
                return;
            }
        }
    }

    public void close() {
        try {
            this.active = false;
            this.mcsocket.leaveGroup(this.group);
            this.mcsocket.close();
        }
        catch (Exception e) {
            Log.debug(e);
        }
    }

    private byte[] getResponse() {
        Dictionary info;
        String httpPort = ProvisioningAgent.bc.getProperty(HTTP_PORT);
        String httpsPort = ProvisioningAgent.bc.getProperty(HTTPS_PORT);
        if (httpPort == null || httpsPort == null) {
            ServiceReference sref = this.bc.getServiceReference("org.osgi.service.http.HttpService");
            if (httpPort == null) {
                httpPort = DiscoveryAgent.getPortProperty(sref, "openPort");
            }
            if (httpsPort == null) {
                httpsPort = DiscoveryAgent.getPortProperty(sref, "secureOpenPort");
            }
        }
        if ((info = this.prvAgent.getInformation()) == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        String spid = (String)info.get("provisioning.spid");
        buff.append(spid == null || spid.length() == 0 ? NULL : spid);
        buff.append('#');
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            host = "unknown";
        }
        buff.append(host);
        buff.append('#');
        buff.append(httpPort);
        buff.append('#');
        buff.append(httpsPort);
        buff.append('#');
        buff.append(info.get("equinox.provisioning.manager.url") != null);
        buff.append('#');
        buff.append('{');
        buff.append("provisioning.reference");
        buff.append('=');
        buff.append(info.get("provisioning.reference"));
        buff.append(',');
        buff.append("provisioning.start.bundle");
        buff.append('=');
        buff.append(info.get("provisioning.start.bundle"));
        buff.append('}');
        buff.append('#');
        buff.append(this.getFlag());
        Log.debug("Discoverer agent sends gw info : " + buff);
        return buff.toString().getBytes();
    }

    public int getFlag() {
        int flag = 0;
        if (this.prvAgent.getHttpAllowed()) {
            try {
                new URL("http://").openConnection();
                flag |= 1;
            }
            catch (Exception exception) {}
        }
        try {
            new URL("rsh://").openConnection();
            flag |= 2;
        }
        catch (Exception exception) {}
        try {
            new URL("https://").openConnection();
            flag |= 4;
        }
        catch (Exception exception) {}
        return flag;
    }

    private static final String getPortProperty(ServiceReference ref, String property) {
        Object ret = ref != null ? ref.getProperty(property) : null;
        return ret == null ? "-1" : "" + ret;
    }
}

