/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPMemberBlock;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassSpecialization
extends PDOMCPPSpecialization
implements ICPPClassSpecialization,
IPDOMMemberOwner,
IPDOMCPPClassType {
    private static final int FIRST_BASE = 44;
    private static final int MEMBERLIST = 48;
    private static final int FLAGS = 78;
    protected static final int RECORD_SIZE = 79;
    private static final byte FLAGS_FINAL = 1;
    private static final byte FLAGS_HAS_OWN_SCOPE = 2;
    private volatile ICPPClassScope fScope;
    private ObjectMap specializationMap;
    private final ThreadLocal<Set<IBinding>> fInProgress = new ThreadLocal<Set<IBinding>>(){

        @Override
        protected Set<IBinding> initialValue() {
            return new HashSet<IBinding>();
        }
    };

    public PDOMCPPClassSpecialization(PDOMCPPLinkage linkage, PDOMNode parent, ICPPClassType classType, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)classType), specialized);
        this.setFlags(classType);
    }

    public PDOMCPPClassSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)newBinding;
            this.setFlags(classType);
            super.update(linkage, newBinding);
        }
    }

    @Override
    protected int getRecordSize() {
        return 79;
    }

    @Override
    public int getNodeType() {
        return 37;
    }

    @Override
    public ICPPClassType getSpecializedBinding() {
        return (ICPPClassType)super.getSpecializedBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinding specializeMember(IBinding original) {
        IBinding newSpec;
        Object key;
        if (this.specializationMap == null) {
            key = this.record + 3L;
            Object cached = this.getPDOM().getCachedResult(key);
            if (cached != null) {
                this.specializationMap = (ObjectMap)cached;
            } else {
                ObjectMap newMap = new ObjectMap(2);
                try {
                    ICPPClassType[] nested;
                    PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
                    PDOMCPPClassScope.acceptViaCache(this, visitor, false);
                    ICPPClassType[] iCPPClassTypeArray = nested = visitor.getNestedClasses();
                    int n = nested.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPClassType classType = iCPPClassTypeArray[n2];
                        if (classType instanceof ICPPSpecialization) {
                            newMap.put(((ICPPSpecialization)((Object)classType)).getSpecializedBinding(), classType);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
                this.specializationMap = (ObjectMap)this.getPDOM().putCachedResult(key, newMap, false);
            }
        }
        key = this.specializationMap;
        synchronized (key) {
            IBinding result = (IBinding)this.specializationMap.get(original);
            if (result != null) {
                return result;
            }
        }
        Set<IBinding> recursionProtectionSet = this.fInProgress.get();
        if (!recursionProtectionSet.add(original)) {
            return CPPClassSpecialization.RecursionResolvingBinding.createFor(original);
        }
        try {
            newSpec = CPPTemplates.createSpecialization(this, original);
        }
        finally {
            recursionProtectionSet.remove(original);
        }
        ObjectMap objectMap = this.specializationMap;
        synchronized (objectMap) {
            IBinding oldSpec = (IBinding)this.specializationMap.put(original, newSpec);
            if (oldSpec != null) {
                this.specializationMap.put(original, oldSpec);
                return oldSpec;
            }
        }
        return newSpec;
    }

    @Override
    @Deprecated
    public IBinding specializeMember(IBinding original, IASTNode point) {
        return this.specializeMember(original);
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        if (this.fScope == null) {
            try {
                if (this.hasOwnScope()) {
                    this.fScope = new PDOMCPPClassScope(this);
                    return this.fScope;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.fScope = new PDOMCPPClassSpecializationScope(this);
        }
        return this.fScope;
    }

    public PDOMCPPBase getFirstBase() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 44L);
        return rec != 0L ? new PDOMCPPBase((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        long rec = base != null ? base.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 44L, rec);
    }

    public void addBases(PDOMName classDefName, ICPPBase[] bases) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        ILinkage linkage = this.getLinkage();
        PDOMCPPBase firstBase = this.getFirstBase();
        ICPPBase[] iCPPBaseArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            PDOMCPPBase nextBase = new PDOMCPPBase((PDOMLinkage)linkage, base, classDefName);
            nextBase.setNextBase(firstBase);
            firstBase = nextBase;
            ++n2;
        }
        this.setFirstBase(firstBase);
    }

    public void removeBases(PDOMName classDefName) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        long nameRec = classDefName.getRecord();
        boolean deleted = false;
        while (base != null) {
            PDOMCPPBase nextBase = base.getNextBase();
            long classDefRec = this.getDB().getRecPtr(base.getRecord() + 0L);
            if (classDefRec == nameRec) {
                deleted = true;
                base.delete();
            } else if (deleted) {
                deleted = false;
                if (predecessor == null) {
                    this.setFirstBase(base);
                } else {
                    predecessor.setNextBase(base);
                }
                predecessor = base;
            }
            base = nextBase;
        }
        if (deleted) {
            if (predecessor == null) {
                this.setFirstBase(null);
            } else {
                predecessor.setNextBase(null);
            }
        }
    }

    @Override
    public ICPPBase[] getBases() {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getBases();
        }
        Long key = this.record + 1L;
        ICPPBase[] bases = (ICPPBase[])this.getPDOM().getCachedResult(key);
        if (bases != null) {
            return bases;
        }
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            bases = list.toArray(new ICPPBase[list.size()]);
            this.getPDOM().putCachedResult(key, bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
    }

    @Override
    @Deprecated
    public ICPPBase[] getBases(IASTNode point) {
        return this.getBases();
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            ICPPConstructor[] constructors = ((ICPPClassSpecializationScope)scope).getConstructors();
            return ClassTypeHelper.getAllConstructors(this, constructors);
        }
        try {
            PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            ICPPConstructor[] constructors = visitor.getConstructors();
            return ClassTypeHelper.getAllConstructors(this, constructors);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
    }

    @Override
    @Deprecated
    public ICPPConstructor[] getConstructors(IASTNode point) {
        return this.getConstructors();
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getDeclaredMethods();
        }
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            PDOMCPPClassScope.acceptViaCache(this, methods, false);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
    }

    @Override
    @Deprecated
    public ICPPMethod[] getDeclaredMethods(IASTNode point) {
        return this.getDeclaredMethods();
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getDeclaredFields();
        }
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }
    }

    @Override
    @Deprecated
    public ICPPField[] getDeclaredFields(IASTNode point) {
        return this.getDeclaredFields();
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getNestedClasses();
        }
        try {
            PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }
    }

    @Override
    @Deprecated
    public ICPPClassType[] getNestedClasses(IASTNode point) {
        return this.getNestedClasses();
    }

    @Override
    public ICPPUsingDeclaration[] getUsingDeclarations() {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getUsingDeclarations();
        }
        try {
            PDOMClassUtil.UsingDeclarationCollector visitor = new PDOMClassUtil.UsingDeclarationCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getUsingDeclarations();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPUsingDeclaration.EMPTY_USING_DECL_ARRAY;
        }
    }

    @Override
    @Deprecated
    public ICPPUsingDeclaration[] getUsingDeclarations(IASTNode point) {
        return this.getUsingDeclarations();
    }

    @Override
    public IBinding[] getFriends() {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getFriends();
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    @Deprecated
    public IBinding[] getFriends(IASTNode point) {
        return this.getFriends();
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ClassTypeHelper.getMethods(this);
    }

    @Override
    @Deprecated
    public ICPPMethod[] getMethods(IASTNode point) {
        return this.getMethods();
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ClassTypeHelper.getAllDeclaredMethods(this);
    }

    @Override
    @Deprecated
    public ICPPMethod[] getAllDeclaredMethods(IASTNode point) {
        return this.getAllDeclaredMethods();
    }

    @Override
    public IField[] getFields() {
        return ClassTypeHelper.getFields(this);
    }

    @Override
    @Deprecated
    public IField[] getFields(IASTNode point) {
        return this.getFields();
    }

    @Override
    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    @Override
    public int getKey() {
        return this.getSpecializedBinding().getKey();
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (!(type instanceof ICPPClassSpecialization)) {
            return false;
        }
        return CPPClassSpecialization.isSameClassSpecialization(this, (ICPPClassSpecialization)type);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void addChild(PDOMNode member) throws CoreException {
        throw new UnsupportedOperationException("addMember method should be called instead.");
    }

    @Override
    public void acceptUncached(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPMemberBlock members = new PDOMCPPMemberBlock((PDOMLinkage)this.getLinkage(), this.record + 48L);
        members.accept(visitor);
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPClassScope.acceptViaCache(this, visitor, false);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isFinal() {
        try {
            return (this.getFlags() & 1) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    private boolean hasOwnScope() throws CoreException {
        return (this.getFlags() & 2) != 0;
    }

    private byte getFlags() throws CoreException {
        return this.getDB().getByte(this.record + 78L);
    }

    private void setFlags(ICPPClassType classType) throws CoreException {
        byte flags = (byte)((classType.isFinal() ? 1 : 0) | (PDOMCPPClassSpecialization.hasOwnScope(classType) ? 2 : 0));
        this.getDB().putByte(this.record + 78L, flags);
    }

    private static boolean hasOwnScope(ICPPClassType classType) {
        if (!(classType instanceof ICPPInternalBinding)) {
            return false;
        }
        ICPPInternalBinding binding = (ICPPInternalBinding)((Object)classType);
        return binding.getDefinition() != null;
    }

    @Override
    public void addMember(PDOMNode member, int visibility) {
        try {
            PDOMCPPMemberBlock members = new PDOMCPPMemberBlock((PDOMLinkage)this.getLinkage(), this.record + 48L);
            members.addMember(member, visibility);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public int getVisibility(IBinding member) {
        try {
            PDOMCPPMemberBlock members = new PDOMCPPMemberBlock((PDOMLinkage)this.getLinkage(), this.record + 48L);
            int visibility = members.getVisibility(member);
            if (visibility < 0) {
                if (member instanceof ICPPSpecialization) {
                    return this.getSpecializedBinding().getVisibility(((ICPPSpecialization)member).getSpecializedBinding());
                }
                throw new IllegalArgumentException(String.valueOf(member.getName()) + " is not a member of " + this.getName());
            }
            return visibility;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 3;
        }
    }

    @Override
    public boolean isVisibleToAdlOnly() {
        return false;
    }

    @Override
    public void setVisibleToAdlOnly(boolean visibleToAdlOnly) throws CoreException {
    }
}

