/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.core.model.IMixedHandle;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RemoveLibraryAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends AbstractElementAction {
    private static final String DEFAULT_TEXT = Messages.getString((String)"DeleteAction.text");
    private boolean hasExecuted = false;

    public DeleteAction(Object selectedObject) {
        this(selectedObject, DEFAULT_TEXT);
    }

    public DeleteAction(Object selectedObject, String text) {
        super(selectedObject, text);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setAccelerator(127);
    }

    @Override
    protected boolean doAction() throws Exception {
        Object element;
        Object[] selection = this.getSelection();
        if (selection instanceof IMixedHandle) {
            selection = ((IMixedHandle)selection).getChildren().toArray();
        }
        if (selection != null && selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) != null && element instanceof LibraryHandle && ((LibraryHandle)element).getHostHandle() != null) {
            return new RemoveLibraryAction(element).doAction();
        }
        if (selection != null) {
            CommandUtils.setVariable("SelectionHandler.Section", selection);
        }
        Object exeResult = null;
        exeResult = CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.deleteCommand", null);
        this.hasExecuted = (Boolean)exeResult;
        CommandUtils.removeVariable("SelectionHandler.Section");
        return Boolean.TRUE.equals(exeResult);
    }

    public boolean isEnabled() {
        Object element;
        Object[] selection = this.getSelection();
        if (selection instanceof IMixedHandle) {
            selection = ((IMixedHandle)selection).getChildren().toArray();
        } else if (selection != null && selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) != null && element instanceof LibraryHandle && ((LibraryHandle)element).getHostHandle() != null) {
            return true;
        }
        Command cmd = this.createDeleteCommand(selection);
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    @Override
    protected String getTransactionLabel() {
        if (this.getSelection() instanceof IStructuredSelection) {
            return Messages.getString((String)"DeleteAction.trans");
        }
        return String.valueOf(DEFAULT_TEXT) + " " + DEUtil.getDisplayLabel((Object)this.getSelection());
    }

    protected Command createDeleteCommand(Object objects) {
        return new DeleteCommand(objects);
    }

    public boolean hasExecuted() {
        return this.hasExecuted;
    }
}

