/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.UserPropertyBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.UserPropertyEvent;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;

public class UserPropertiesHandleProvier
extends AbstractFormHandleProvider {
    private static final int[] COLUMN_WIDTHS = new int[]{250, 250};
    private static final String[] COLUMNS = new String[]{Messages.getString((String)"UserPropertiesHandleProvier.Column.Name"), Messages.getString((String)"UserPropertiesHandleProvier.Column.Type")};
    private static final String TITLE = Messages.getString((String)"ReportPageGenerator.List.UserProperties");
    private DesignElementHandle inputElement;

    @Override
    public String[] getColumnNames() {
        return COLUMNS;
    }

    @Override
    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    @Override
    public String getDisplayName() {
        return TITLE;
    }

    @Override
    public CellEditor[] getEditors(Table table) {
        return null;
    }

    @Override
    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        return false;
    }

    @Override
    public boolean doDeleteItem(int pos) throws Exception {
        this.inputElement.dropUserPropertyDefn(((UserPropertyDefn)this.getElements(this.inputElement)[pos]).getName());
        return true;
    }

    @Override
    public boolean doAddItem(int pos) throws Exception {
        UserPropertyBuilder builder = new UserPropertyBuilder(0);
        builder.setInput(this.inputElement);
        if (builder.open() == 0) {
            this.inputElement.addUserPropertyDefn((UserPropertyDefn)builder.getResult());
            return true;
        }
        return false;
    }

    @Override
    public boolean doEditItem(int pos) {
        return false;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        UserPropertyDefn def = (UserPropertyDefn)element;
        if (columnIndex == 0) {
            return def.getName();
        }
        return def.getType().getDisplayName();
    }

    @Override
    public Image getImage(Object element, int columnIndex) {
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).get(0);
        }
        if (inputElement instanceof DesignElementHandle) {
            this.inputElement = (DesignElementHandle)inputElement;
            ArrayList userProperties = new ArrayList();
            userProperties.addAll(((DesignElementHandle)inputElement).getUserProperties());
            int i = 0;
            while (i < userProperties.size()) {
                UserPropertyDefn defn = (UserPropertyDefn)userProperties.get(i);
                if (!defn.isVisible()) {
                    userProperties.remove(i);
                    --i;
                }
                ++i;
            }
            return userProperties.toArray();
        }
        return null;
    }

    @Override
    public boolean canModify(Object element, String property) {
        return true;
    }

    @Override
    public Object getValue(Object element, String property) {
        return null;
    }

    @Override
    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    @Override
    public boolean needRefreshed(NotificationEvent event) {
        return event instanceof UserPropertyEvent;
    }
}

