/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text;

import com.opencsv.bean.MappingStrategy;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;

public abstract class SPARQLResultsXSVMappingStrategy
implements MappingStrategy<BindingSet> {
    protected List<String> bindingNames = null;
    protected final ValueFactory valueFactory;
    protected static final Pattern numberPattern = Pattern.compile("^[-+]?[\\d.].*");
    private static final String WRITING_UNSUPPORTED = "This mapping strategy does not write.";

    public SPARQLResultsXSVMappingStrategy(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public List<String> getBindingNames() {
        return this.bindingNames;
    }

    public String[] generateHeader(BindingSet bean) {
        throw new UnsupportedOperationException(WRITING_UNSUPPORTED);
    }

    public boolean isAnnotationDriven() {
        return true;
    }

    protected Value parseNumberPatternMatch(String valueString) {
        IRI dataType = null;
        if (XMLDatatypeUtil.isValidInteger((String)valueString)) {
            dataType = XMLDatatypeUtil.isValidNegativeInteger((String)valueString) ? XSD.NEGATIVE_INTEGER : XSD.INTEGER;
        } else if (XMLDatatypeUtil.isValidDecimal((String)valueString)) {
            dataType = XSD.DECIMAL;
        } else if (XMLDatatypeUtil.isValidDouble((String)valueString)) {
            dataType = XSD.DOUBLE;
        }
        return dataType != null ? this.valueFactory.createLiteral(valueString, dataType) : this.valueFactory.createLiteral(valueString);
    }

    public void setErrorLocale(Locale errorLocale) {
    }

    public void setType(Class<? extends BindingSet> type) {
    }

    public String[] transmuteBean(BindingSet bean) {
        throw new UnsupportedOperationException(WRITING_UNSUPPORTED);
    }
}

