/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableCharDoubleMapFactory;
import org.eclipse.collections.api.map.primitive.CharDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharDoubleMap;
import org.eclipse.collections.impl.factory.primitive.CharDoubleMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharDoubleEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharDoubleHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharDoubleSingletonMap;

public enum ImmutableCharDoubleMapFactoryImpl implements ImmutableCharDoubleMapFactory
{
    INSTANCE;


    public ImmutableCharDoubleMap empty() {
        return ImmutableCharDoubleEmptyMap.INSTANCE;
    }

    public ImmutableCharDoubleMap of() {
        return this.empty();
    }

    public ImmutableCharDoubleMap with() {
        return this.empty();
    }

    public ImmutableCharDoubleMap of(char key, double value) {
        return this.with(key, value);
    }

    public ImmutableCharDoubleMap with(char key, double value) {
        return new ImmutableCharDoubleSingletonMap(key, value);
    }

    public ImmutableCharDoubleMap ofAll(CharDoubleMap map) {
        return this.withAll(map);
    }

    public ImmutableCharDoubleMap withAll(CharDoubleMap map) {
        if (map instanceof ImmutableCharDoubleMap) {
            return (ImmutableCharDoubleMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableCharDoubleHashMap(map);
    }

    public <T> ImmutableCharDoubleMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction) {
        return CharDoubleMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

