/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqlxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.common.xml.SimpleSAXParser;
import org.eclipse.rdf4j.common.xml.XMLReaderFactory;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLBooleanSAXParser;
import org.eclipse.rdf4j.query.resultio.sparqlxml.SPARQLResultsSAXParser;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSPARQLXMLParser
extends AbstractQueryResultParser
implements ErrorHandler {
    private SimpleSAXParser internalSAXParser;

    protected AbstractSPARQLXMLParser() {
    }

    protected AbstractSPARQLXMLParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parseQueryResultInternal(in, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected boolean parseQueryResultInternal(InputStream in, boolean attemptParseBoolean, boolean attemptParseTuple) throws IOException, QueryResultParseException, QueryResultHandlerException {
        if (!attemptParseBoolean && !attemptParseTuple) {
            throw new IllegalArgumentException("Internal error: Did not specify whether to parse as either boolean and/or tuple");
        }
        buff = new BufferedInputStream(in);
        uncloseable = new UncloseableInputStream(buff);
        caughtException = null;
        result = false;
        try {
            if (!attemptParseBoolean) ** GOTO lbl75
            buff.mark(0x7FFFFFFF);
            try {
                valueParser = new SPARQLBooleanSAXParser();
                xmlReader = this.getParserConfig().isSet(XMLParserSettings.CUSTOM_XML_READER) != false ? this.getParserConfig().get(XMLParserSettings.CUSTOM_XML_READER) : XMLReaderFactory.createXMLReader();
                xmlReader.setErrorHandler(this);
                for (RioSetting<Boolean> aSetting : this.getCompulsoryXmlFeatureSettings()) {
                    try {
                        xmlReader.setFeature(aSetting.getKey(), this.getParserConfig().get(aSetting));
                    }
                    catch (SAXNotRecognizedException e) {
                        this.reportWarning(String.format("%s is not a recognized SAX feature.", new Object[]{aSetting.getKey()}));
                    }
                    catch (SAXNotSupportedException e) {
                        this.reportWarning(String.format("%s is not a supported SAX feature.", new Object[]{aSetting.getKey()}));
                    }
                }
                for (RioSetting<Boolean> aSetting : this.getCompulsoryXmlPropertySettings()) {
                    try {
                        xmlReader.setProperty(aSetting.getKey(), this.getParserConfig().get(aSetting));
                    }
                    catch (SAXNotRecognizedException e) {
                        this.reportWarning(String.format("%s is not a recognized SAX property.", new Object[]{aSetting.getKey()}));
                    }
                    catch (SAXNotSupportedException e) {
                        this.reportWarning(String.format("%s is not a supported SAX property.", new Object[]{aSetting.getKey()}));
                    }
                }
                for (RioSetting<Boolean> aSetting : this.getOptionalXmlFeatureSettings()) {
                    try {
                        if (!this.getParserConfig().isSet(aSetting)) continue;
                        xmlReader.setFeature(aSetting.getKey(), this.getParserConfig().get(aSetting));
                    }
                    catch (SAXNotRecognizedException e) {
                        this.reportWarning(String.format("%s is not a recognized SAX feature.", new Object[]{aSetting.getKey()}));
                    }
                    catch (SAXNotSupportedException e) {
                        this.reportWarning(String.format("%s is not a supported SAX feature.", new Object[]{aSetting.getKey()}));
                    }
                }
                for (RioSetting<Boolean> aSetting : this.getOptionalXmlPropertySettings()) {
                    try {
                        if (!this.getParserConfig().isSet(aSetting)) continue;
                        xmlReader.setProperty(aSetting.getKey(), this.getParserConfig().get(aSetting));
                    }
                    catch (SAXNotRecognizedException e) {
                        this.reportWarning(String.format("%s is not a recognized SAX property.", new Object[]{aSetting.getKey()}));
                    }
                    catch (SAXNotSupportedException e) {
                        this.reportWarning(String.format("%s is not a supported SAX property.", new Object[]{aSetting.getKey()}));
                    }
                }
                this.internalSAXParser = new SimpleSAXParser(xmlReader);
                this.internalSAXParser.setPreserveWhitespace(true);
                this.internalSAXParser.setListener(valueParser);
                this.internalSAXParser.parse(uncloseable);
                result = valueParser.getValue();
                try {
                    if (this.handler != null) {
                        this.handler.handleBoolean(result);
                    }
                }
                catch (QueryResultHandlerException e) {
                    if (e.getCause() != null && e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new QueryResultParseException("Found an issue with the query result handler", e);
                }
                var10_15 = result;
                return var10_15;
            }
            catch (SAXException e) {
                caughtException = e;
                buff.reset();
lbl75:
                // 2 sources

                if (attemptParseTuple) {
                    try {
                        xmlReader = XMLReaderFactory.createXMLReader();
                        xmlReader.setErrorHandler(this);
                        this.internalSAXParser = new SimpleSAXParser(xmlReader);
                        this.internalSAXParser.setPreserveWhitespace(true);
                        this.internalSAXParser.setListener(new SPARQLResultsSAXParser(this.valueFactory, this.handler));
                        this.internalSAXParser.parse(uncloseable);
                        caughtException = null;
                    }
                    catch (SAXException e) {
                        caughtException = e;
                    }
                }
                if (caughtException != null) {
                    wrappedExc = caughtException.getException();
                    if (wrappedExc == null) {
                        throw new QueryResultParseException(caughtException);
                    }
                    if (wrappedExc instanceof QueryResultParseException) {
                        throw (QueryResultParseException)wrappedExc;
                    }
                    if (wrappedExc instanceof QueryResultHandlerException) {
                        throw (QueryResultHandlerException)wrappedExc;
                    }
                    throw new QueryResultParseException(wrappedExc);
                }
            }
        }
        finally {
            uncloseable.doClose();
        }
        return result;
    }

    protected void reportWarning(String msg) {
        if (this.getParseErrorListener() != null) {
            this.getParseErrorListener().warning(msg, this.internalSAXParser.getLocator().getLineNumber(), this.internalSAXParser.getLocator().getColumnNumber());
        }
    }

    public Collection<RioSetting<?>> getCompulsoryXmlPropertySettings() {
        return Collections.emptyList();
    }

    public Collection<RioSetting<Boolean>> getCompulsoryXmlFeatureSettings() {
        HashSet<RioSetting<Boolean>> results = new HashSet<RioSetting<Boolean>>();
        results.add(XMLParserSettings.SECURE_PROCESSING);
        results.add(XMLParserSettings.DISALLOW_DOCTYPE_DECL);
        results.add(XMLParserSettings.EXTERNAL_GENERAL_ENTITIES);
        results.add(XMLParserSettings.EXTERNAL_PARAMETER_ENTITIES);
        return results;
    }

    public Collection<RioSetting<?>> getOptionalXmlPropertySettings() {
        return Collections.emptyList();
    }

    public Collection<RioSetting<Boolean>> getOptionalXmlFeatureSettings() {
        HashSet<RioSetting<Boolean>> results = new HashSet<RioSetting<Boolean>>();
        results.add(XMLParserSettings.LOAD_EXTERNAL_DTD);
        return results;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.addAll(this.getCompulsoryXmlPropertySettings());
        results.addAll(this.getCompulsoryXmlFeatureSettings());
        results.addAll(this.getOptionalXmlPropertySettings());
        results.addAll(this.getOptionalXmlFeatureSettings());
        results.add(XMLParserSettings.CUSTOM_XML_READER);
        results.add(XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS);
        return results;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.reportWarning(exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        try {
            if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS).booleanValue()) {
                if (this.getParseErrorListener() != null) {
                    this.getParseErrorListener().error(exception.getMessage(), this.internalSAXParser.getLocator().getLineNumber(), this.internalSAXParser.getLocator().getColumnNumber());
                }
                if (!this.getParserConfig().isNonFatalError(XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS)) {
                    throw new QueryResultParseException(exception, (long)this.internalSAXParser.getLocator().getLineNumber(), (long)this.internalSAXParser.getLocator().getColumnNumber());
                }
            }
        }
        catch (QueryResultParseException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.getParseErrorListener() != null) {
            this.getParseErrorListener().fatalError(exception.getMessage(), this.internalSAXParser.getLocator().getLineNumber(), this.internalSAXParser.getLocator().getColumnNumber());
        }
        throw new SAXParseException(exception.getMessage(), this.internalSAXParser.getLocator(), new QueryResultParseException(exception, (long)this.internalSAXParser.getLocator().getLineNumber(), (long)this.internalSAXParser.getLocator().getColumnNumber()));
    }
}

