/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.workspace;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProjectUtil {
    public static final Object MIGRATION_FAMILY = new Object();

    public static IProject[] projects() throws InterruptedException {
        try {
            Job.getJobManager().join(MIGRATION_FAMILY, null);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    private static void openProjects(PrintStream out) throws CoreException {
        ProjectUtil.print(out, "Refreshing projects:%n", new Object[0]);
        try {
            IProject[] iProjectArray = ProjectUtil.projects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                ProjectUtil.print(out, "    %s... ", project.getName());
                if (project.isOpen()) {
                    ProjectUtil.print(out, "OK%n", new Object[0]);
                } else {
                    try {
                        project.open((IProgressMonitor)new NullProgressMonitor());
                        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        throw ProjectUtil.printAndThrow(out, e.getStatus());
                    }
                    ProjectUtil.print(out, "OK%n", new Object[0]);
                }
                ++n2;
            }
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.core", "Interrupted", (Throwable)e));
        }
    }

    public static void importProjects(File[] projectDirs, PrintStream out) throws CoreException {
        ProjectUtil.importProjects(Arrays.asList(projectDirs), out);
    }

    public static void importProjects(List<File> projectDirs, PrintStream out) throws CoreException {
        LinkedHashSet<File> projectsToImport = new LinkedHashSet<File>();
        HashSet<File> existingProjects = new HashSet<File>(ProjectUtil.existingProjects());
        ProjectUtil.print(out, "Existing projects in workspace:%n", new Object[0]);
        ProjectUtil.printFiles(out, existingProjects);
        for (File file : projectDirs) {
            ProjectUtil.collectProjects(file, projectsToImport, existingProjects);
        }
        if (projectsToImport.isEmpty()) {
            ProjectUtil.print(out, "No projects to import%n", new Object[0]);
            return;
        }
        ProjectUtil.print(out, "Importing projects to workspace:%n", new Object[0]);
        ProjectUtil.openProjects(out);
        for (File file : projectsToImport) {
            ProjectUtil.print(out, "    %s... ", file.getAbsolutePath());
            IStatus result = ProjectUtil.importProject(file);
            if (result.isOK()) {
                ProjectUtil.print(out, "OK%n", new Object[0]);
                continue;
            }
            throw ProjectUtil.printAndThrow(out, result);
        }
        ProjectUtil.openProjects(out);
    }

    private static void printFiles(PrintStream out, Collection<File> files) {
        if (files.isEmpty()) {
            ProjectUtil.print(out, "    <none>%n", new Object[0]);
            return;
        }
        for (File file : files) {
            ProjectUtil.print(out, "    %s%n", file.getAbsolutePath());
        }
    }

    private static void print(PrintStream out, String format, Object ... args) {
        if (out == null) {
            return;
        }
        out.print(String.format(format, args));
    }

    private static CoreException printAndThrow(PrintStream out, IStatus status) {
        ProjectUtil.print(out, "ERROR %s%n", status.getMessage());
        if (status.getException() != null) {
            status.getException().printStackTrace(out);
        }
        return new CoreException(status);
    }

    private static void collectProjects(File dir, Set<File> result, Set<File> ignore) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        if (ignore.contains(dir)) {
            return;
        }
        if (ProjectUtil.isProject(dir)) {
            result.add(dir);
            return;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            ProjectUtil.collectProjects(child, result, ignore);
            ++n2;
        }
    }

    private static File getDescriptor(File projectDir) {
        return new File(projectDir, ".project");
    }

    private static boolean isDefaultLocation(IPath path) {
        if (path.segmentCount() < 2) {
            return false;
        }
        return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
    }

    private static IStatus importProject(File dir) {
        IProjectDescription description;
        String projectName;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File descriptorFile = ProjectUtil.getDescriptor(dir);
        Path descriptorPath = new Path(descriptorFile.getAbsolutePath());
        Path locationPath = new Path(dir.getAbsolutePath());
        if (ProjectUtil.isDefaultLocation((IPath)descriptorPath)) {
            projectName = descriptorPath.segment(descriptorPath.segmentCount() - 2);
            description = workspace.newProjectDescription(projectName);
        } else {
            try {
                description = workspace.loadProjectDescription((IPath)descriptorPath);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            projectName = description.getName();
        }
        description.setLocation((IPath)locationPath);
        IProject project = workspace.getRoot().getProject(projectName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private static boolean isProject(File file) {
        return file.isDirectory() && ProjectUtil.getDescriptor(file).exists();
    }

    private static List<File> existingProjects() {
        ArrayList<File> result = new ArrayList<File>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            result.add(new File(project.getLocation().toOSString()));
            ++n2;
        }
        return result;
    }
}

