/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.jgit.lib.Repository;

public class WorkingTreeFileRevision
extends GitFileRevision {
    private final IPath filePath;

    public WorkingTreeFileRevision(Repository repository, String path) {
        super(repository, path);
        this.filePath = Path.fromOSString((String)repository.getWorkTree().getAbsolutePath()).append(path);
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return new IStorage(){

            public <T> T getAdapter(Class<T> adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getName() {
                return WorkingTreeFileRevision.this.filePath.lastSegment();
            }

            public IPath getFullPath() {
                return WorkingTreeFileRevision.this.filePath;
            }

            public InputStream getContents() throws CoreException {
                try {
                    return Files.newInputStream(WorkingTreeFileRevision.this.filePath.toFile().toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
            }
        };
    }

    @Override
    public boolean isPropertyMissing() {
        return false;
    }

    public String getAuthor() {
        return "";
    }

    public long getTimestamp() {
        return -1L;
    }

    public String getComment() {
        return "";
    }

    public String getContentIdentifier() {
        return "Working Tree";
    }

    @Override
    public GitInfo.Source getSource() {
        return GitInfo.Source.WORKING_TREE;
    }
}

