/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.debug.model;

import org.eclipse.ant.internal.launching.AntLaunchingUtil;
import org.eclipse.ant.internal.launching.debug.model.AntDebugElement;
import org.eclipse.ant.internal.launching.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.launching.debug.model.AntProperties;
import org.eclipse.ant.internal.launching.debug.model.AntPropertiesValue;
import org.eclipse.ant.internal.launching.debug.model.AntProperty;
import org.eclipse.ant.internal.launching.debug.model.AntThread;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class AntStackFrame
extends AntDebugElement
implements IStackFrame {
    private final AntThread fThread;
    private String fName;
    private int fLineNumber;
    private String fFilePath;
    private int fId;
    private String fFullPath;

    public AntStackFrame(AntThread antThread, int id, String name, String fullPath, int lineNumber) {
        super((AntDebugTarget)antThread.getDebugTarget());
        this.fId = id;
        this.fThread = antThread;
        this.fLineNumber = lineNumber;
        this.fName = name;
        this.setFilePath(fullPath);
    }

    public void setId(int id) {
        this.fId = id;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.fThread.getVariables();
    }

    public boolean hasVariables() {
        return this.isSuspended();
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    public void setFilePath(String fullPath) {
        this.fFullPath = fullPath;
        IFile file = AntLaunchingUtil.getFileForLocation(fullPath, null);
        this.fFilePath = file != null ? file.getProjectRelativePath().toString() : IPath.fromOSString((String)fullPath).lastSegment();
    }

    public String getFilePath() {
        return this.fFullPath;
    }

    public int getCharStart() {
        return -1;
    }

    public int getCharEnd() {
        return -1;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public IRegisterGroup[] getRegisterGroups() {
        return null;
    }

    public boolean hasRegisterGroups() {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fFilePath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AntStackFrame) {
            AntStackFrame sf = (AntStackFrame)((Object)obj);
            if (this.getSourceName() != null) {
                return this.getSourceName().equals(sf.getSourceName()) && sf.getLineNumber() == this.getLineNumber() && sf.fId == this.fId;
            }
            return sf.fId == this.fId;
        }
        return false;
    }

    public int hashCode() {
        if (this.getSourceName() == null) {
            return this.fId;
        }
        return this.getSourceName().hashCode() + this.fId;
    }

    protected int getIdentifier() {
        return this.fId;
    }

    public AntProperty findProperty(String propertyName) {
        try {
            IVariable[] iVariableArray = this.getVariables();
            int n = iVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable group = iVariableArray[n2];
                AntProperties propertiesGrouping = (AntProperties)group;
                AntPropertiesValue value = (AntPropertiesValue)propertiesGrouping.getValue();
                IVariable[] iVariableArray2 = value.getVariables();
                int n3 = iVariableArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVariable currproperty = iVariableArray2[n4];
                    AntProperty property = (AntProperty)currproperty;
                    if (property.getName().equals(propertyName)) {
                        return property;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return null;
    }
}

