/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.serializers;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializerConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSSerializer {
    public void serialize(Writer writer, CSSEngine engine, Object element, boolean serializeChildNodes) throws IOException {
        this.serialize(writer, engine, element, serializeChildNodes, null);
    }

    public void serialize(Writer writer, CSSEngine engine, Object element, boolean serializeChildNodes, CSSSerializerConfiguration configuration) throws IOException {
        HashMap<String, CSSStyleDeclaration> selectors = new HashMap<String, CSSStyleDeclaration>();
        this.serialize(writer, engine, element, serializeChildNodes, selectors, configuration);
        boolean firstSelector = true;
        for (Map.Entry entry : selectors.entrySet()) {
            String selectorName = (String)entry.getKey();
            CSSStyleDeclaration styleDeclaration = (CSSStyleDeclaration)entry.getValue();
            if (styleDeclaration == null) continue;
            int length = styleDeclaration.getLength();
            this.startSelector(writer, selectorName, firstSelector);
            firstSelector = false;
            int i = 0;
            while (i < length) {
                String propertyName = styleDeclaration.item(i);
                String propertyValue = styleDeclaration.getPropertyValue(propertyName);
                this.property(writer, propertyName, propertyValue);
                ++i;
            }
            this.endSelector(writer, selectorName);
        }
    }

    protected void serialize(Writer writer, CSSEngine engine, Object element, boolean serializeChildNodes, Map<String, CSSStyleDeclaration> selectors, CSSSerializerConfiguration configuration) throws IOException {
        Element elt = engine.getElement(element);
        if (elt != null) {
            NodeList nodes;
            StringBuilder selectorName = new StringBuilder(elt.getLocalName());
            CSSStyleDeclaration styleDeclaration = engine.getDefaultStyleDeclaration(element, null);
            if (configuration != null) {
                String[] attributesFilter = configuration.getAttributesFilter();
                int i = 0;
                while (i < attributesFilter.length) {
                    String attributeFilter = attributesFilter[i];
                    String value = elt.getAttribute(attributeFilter);
                    if (value != null && value.length() > 0) {
                        selectorName.append("[");
                        selectorName.append(attributeFilter);
                        selectorName.append("=");
                        if (value.indexOf(".") != -1) {
                            value = "'" + value + "'";
                        }
                        selectorName.append(value);
                        selectorName.append("]");
                        break;
                    }
                    ++i;
                }
            }
            selectors.put(selectorName.toString(), styleDeclaration);
            if (serializeChildNodes && (nodes = elt.getChildNodes()) != null) {
                int k = 0;
                while (k < nodes.getLength()) {
                    this.serialize(writer, engine, nodes.item(k), serializeChildNodes, selectors, configuration);
                    ++k;
                }
            }
        }
    }

    protected void startSelector(Writer writer, String selectorName, boolean firstSelector) throws IOException {
        if (!firstSelector) {
            writer.write("\n\n");
        }
        writer.write(String.valueOf(selectorName) + " {");
    }

    protected void endSelector(Writer writer, String selectorName) throws IOException {
        writer.write("\n}");
    }

    private void property(Writer writer, String propertyName, String propertyValue) throws IOException {
        writer.write("\n\t" + propertyName + ":" + propertyValue + ";");
    }
}

