/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.nodejs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.cf.utils.Packager;
import org.eclipse.orion.server.core.IOUtilities;
import org.json.JSONObject;

public class CFLauncherPackager
extends Packager {
    protected JSONObject packageJSON;

    public CFLauncherPackager(IFileStore base, JSONObject packageJSON) {
        super(base);
        this.packageJSON = packageJSON;
    }

    protected boolean isPackageJSON(IFileStore source, IPath path) {
        return "package.json".equals(path.toString()) && "package.json".equals(source.fetchInfo().getName());
    }

    @Override
    protected boolean isIgnored(IFileStore source, IPath path, boolean isDirectory) throws CoreException {
        return this.isPackageJSON(source, path) ? true : super.isIgnored(source, path, isDirectory);
    }

    @Override
    public void writeZip(IFileStore source, ZipOutputStream zos) throws CoreException, IOException {
        this.writeZip(source, (IPath)Path.EMPTY, zos);
        ByteArrayInputStream packageStream = new ByteArrayInputStream(this.packageJSON.toString().getBytes("UTF-8"));
        zos.putNextEntry(new ZipEntry(Path.EMPTY.append("package.json").toString()));
        IOUtilities.pipe((InputStream)packageStream, (OutputStream)zos, (boolean)true, (boolean)false);
    }
}

