/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.git.servlets.GenericGitHandler;
import org.eclipse.orion.server.git.servlets.GitHandlerV1;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class ServletGitHandler
extends ServletResourceHandler<String> {
    public static VersionRange VERSION1 = new VersionRange("[1,2)");
    private final ServletResourceHandler<String> genericGitHandler;
    private final ServletResourceHandler<String> gitHandlerV1;
    final ServletResourceHandler<IStatus> statusHandler;

    ServletGitHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
        this.genericGitHandler = new GenericGitHandler(statusHandler);
        this.gitHandlerV1 = new GitHandlerV1(statusHandler);
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String gitPathInfo) throws ServletException {
        String versionString = request.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        ServletResourceHandler<String> handler = version == null || VERSION1.isIncluded(version) ? this.gitHandlerV1 : this.genericGitHandler;
        return handler.handleRequest(request, response, (Object)gitPathInfo);
    }
}

