/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.useradmin;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.useradmin.UserEmailUtil;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserHandlerV1
extends ServletResourceHandler<String> {
    private static final int PASSWORD_MIN_LENGTH = 8;
    private static final String ROWS = "rows";
    private static final String START = "start";
    private static final int USERNAME_MAX_LENGTH = 20;
    private static final int USERNAME_MIN_LENGTH = 3;
    public static final String USERS = "Users";
    public static final String USERS_LENGTH = "UsersLength";
    public static final String USERS_ROWS = "UsersRows";
    public static final String USERS_START = "UsersStart";
    private ServletResourceHandler<IStatus> statusHandler;

    UserHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    private JSONObject formJson(UserInfo userInfo, URI location, String contextPath) throws JSONException, CoreException {
        JSONObject json = new JSONObject();
        json.put("UserName", (Object)userInfo.getUserName());
        json.put("FullName", (Object)userInfo.getFullName());
        json.put("Location", (Object)(String.valueOf(contextPath) + location.getPath()));
        String email = userInfo.getProperty("Email");
        json.put("Email", (Object)email);
        boolean emailConfirmed = email != null && email.length() > 0 ? userInfo.getProperty("EmailConfirmationId") == null : false;
        json.put("EmailConfirmed", emailConfirmed);
        json.put("HasPassword", userInfo.getProperty("Password") != null);
        if (userInfo.getProperty("OAuth") != null) {
            json.put("OAuth", (Object)userInfo.getProperty("OAuth"));
        }
        if (userInfo.getProperty("OpenId") != null) {
            json.put("OpenId", (Object)userInfo.getProperty("OpenId"));
        }
        json.put("LastLoginTimestamp", (Object)userInfo.getProperty("LastLoginTimestamp"));
        json.put("DiskUsageTimestamp", (Object)userInfo.getProperty("DiskUsageTimestamp"));
        json.put("DiskUsage", (Object)userInfo.getProperty("DiskUsage"));
        return json;
    }

    private List<String> getAllUsers() throws CoreException {
        List users = OrionConfiguration.getMetaStore().readAllUsers();
        Collections.sort(users, new Comparator<String>(){

            @Override
            public int compare(String userId1, String userId2) {
                return userId1.compareTo(userId2);
            }
        });
        return users;
    }

    private String getUniqueEmailConfirmationId() {
        return String.valueOf(System.currentTimeMillis()) + "-" + Math.random();
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String userPathInfo) throws ServletException {
        if (userPathInfo == null) {
            try {
                switch (UserHandlerV1.getMethod(request)) {
                    case GET: {
                        return this.handleUsersGet(request, response);
                    }
                    case POST: {
                        JSONObject json = OrionServlet.readJSONRequest(request);
                        if (json.has("Reset")) break;
                        return this.handleUserCreate(request, response, json);
                    }
                }
                return false;
            }
            catch (JSONException e) {
                return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
            }
            catch (Exception e) {
                throw new ServletException("Error handling users", (Throwable)e);
            }
        }
        String[] userPathInfoParts = userPathInfo.split("\\/", 2);
        String username = userPathInfoParts[1];
        try {
            switch (UserHandlerV1.getMethod(request)) {
                case GET: {
                    return this.handleUserGet(request, response, username);
                }
                case PUT: {
                    return this.handleUserPut(request, response, username);
                }
                case DELETE: {
                    return this.handleUserDelete(request, response, username);
                }
                case POST: {
                    JSONObject json = OrionServlet.readJSONRequest(request);
                    if (!json.has("Reset")) break;
                    return this.handleUserReset(request, response, username, json);
                }
            }
            return false;
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        catch (Exception e) {
            throw new ServletException(NLS.bind((String)"Error handling user: {0}", (Object)username), (Throwable)e);
        }
    }

    private boolean handleUserCreate(HttpServletRequest req, HttpServletResponse resp, JSONObject json) throws ServletException, IOException, JSONException, CoreException {
        String msg;
        String username = json.has("UserName") ? json.getString("UserName") : null;
        String fullname = json.has("FullName") ? json.getString("FullName") : null;
        String email = json.has("Email") ? json.getString("Email") : null;
        String password = json.has("Password") ? json.getString("Password") : null;
        String identifier = json.has("identifier") ? json.getString("identifier") : null;
        boolean isEmailRequired = Boolean.TRUE.toString().equalsIgnoreCase(PreferenceHelper.getString((String)"orion.auth.user.creation.force.email"));
        if (fullname == null) {
            fullname = username;
        }
        if ((msg = this.validateLogin(username)) != null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg, null));
        }
        String passwordMsg = this.validatePassword(password);
        if (passwordMsg != null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, passwordMsg, null));
        }
        if (isEmailRequired && (email == null || email.length() == 0)) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "User email is mandatory.", null));
        }
        UserInfo userInfo = null;
        try {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", username, false, false);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        if (userInfo != null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "User " + username + " already exists.", null));
        }
        if (email != null && email.length() > 0) {
            if (!email.contains("@")) {
                return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "Invalid user email.", null));
            }
            userInfo = null;
            try {
                userInfo = OrionConfiguration.getMetaStore().readUserByProperty("Email", email.toLowerCase(), false, false);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
                return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
            }
            if (userInfo != null) {
                return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, NLS.bind((String)"Email address already in use: {0}.", (Object)email), null));
            }
        }
        userInfo = new UserInfo();
        userInfo.setUserName(username);
        userInfo.setFullName(fullname);
        userInfo.setProperty("Password", password);
        if (identifier != null) {
            userInfo.setProperty("OAuth", identifier);
        }
        if (email != null && email.length() > 0) {
            userInfo.setProperty("Email", email);
        }
        if (isEmailRequired) {
            userInfo.setProperty("Blocked", "true");
            userInfo.setProperty("EmailConfirmationId", this.getUniqueEmailConfirmationId());
        }
        try {
            OrionConfiguration.getMetaStore().createUser(userInfo);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, NLS.bind((String)"Error creating user: {0}", (Object)username), null));
        }
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.account");
        if (logger.isInfoEnabled()) {
            logger.info("Account created: " + username);
        }
        try {
            String location = "/users/" + userInfo.getUniqueId();
            AuthorizationService.addUserRight(userInfo.getUniqueId(), location);
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "User rights could not be added.", (Throwable)e));
        }
        URI userLocation = URIUtil.append((URI)ServletResourceHandler.getURI(req), (String)userInfo.getUniqueId());
        if (isEmailRequired) {
            try {
                UserEmailUtil.getUtil().sendEmailConfirmation(req, userInfo);
                return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 201, NLS.bind((String)"Your account {0} has been successfully created. You have been sent an email address verification. Follow the instructions in this email to login to your Orion account.", (Object)username), null));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
                return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "Could not send confirmation email to " + userInfo.getProperty("Email"), null));
            }
        }
        OrionServlet.writeJSONResponse(req, resp, this.formJson(userInfo, userLocation, req.getContextPath()));
        if (email != null && email.length() > 0 && UserEmailUtil.getUtil().isEmailConfigured()) {
            try {
                UserEmailUtil.getUtil().sendEmailConfirmation(req, userInfo);
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
        }
        resp.setStatus(201);
        return true;
    }

    private boolean handleUserDelete(HttpServletRequest req, HttpServletResponse resp, String username) throws ServletException {
        UserInfo userInfo = null;
        try {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", username, false, false);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, "Removing " + username + " failed.", (Throwable)e));
        }
        if (userInfo == null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "User " + username + " could not be found.", null));
        }
        try {
            Activator.getDefault();
            IMetaStore metastore = OrionConfiguration.getMetaStore();
            if (userInfo.getWorkspaceIds().size() > 0) {
                for (String workspaceId : userInfo.getWorkspaceIds()) {
                    WorkspaceInfo workspaceInfo = metastore.readWorkspace(workspaceId);
                    if (workspaceInfo.getProjectNames().size() <= 0) continue;
                    for (String projectName : workspaceInfo.getProjectNames()) {
                        ProjectInfo projectInfo = metastore.readProject(workspaceId, projectName);
                        if (projectInfo == null) continue;
                        WorkspaceResourceHandler.removeProject(username, workspaceInfo, projectInfo);
                    }
                }
            }
            metastore.deleteUser(username);
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, "Removing " + username + " failed.", (Throwable)e));
        }
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.account");
        if (logger.isInfoEnabled()) {
            logger.info("Account deleted: " + username);
        }
        return true;
    }

    private boolean handleUserGet(HttpServletRequest req, HttpServletResponse resp, String username) throws IOException, JSONException, ServletException, CoreException {
        UserInfo userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", username, false, false);
        if (userInfo == null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 404, "User not found " + username, null));
        }
        URI location = ServletResourceHandler.getURI(req);
        OrionServlet.writeJSONResponse(req, resp, this.formJson(userInfo, location, req.getContextPath()));
        return true;
    }

    private boolean handleUserPut(HttpServletRequest req, HttpServletResponse resp, String username) throws ServletException, IOException, CoreException, JSONException {
        JSONObject data = OrionServlet.readJSONRequest(req);
        UserInfo userInfo = null;
        try {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", username, false, false);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        if (userInfo == null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "User " + username + " could not be found.", null));
        }
        String emailConfirmationid = userInfo.getProperty("EmailConfirmationId");
        if (!(this.isAdmin(req.getRemoteUser()) || !data.has("Password") || userInfo.getProperty("Password") == null || data.has("OldPassword") && userInfo.getProperty("Password").equals(data.getString("OldPassword")))) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "Invalid old password", null));
        }
        String newPassword = null;
        if (data.has("Password")) {
            newPassword = data.getString("Password");
        }
        String passwordMsg = this.validatePassword(newPassword);
        if (data.has("OldPassword") && passwordMsg != null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, passwordMsg, null));
        }
        if (data.has("UserName")) {
            userInfo.setUserName(data.getString("UserName"));
        }
        if (data.has("FullName")) {
            userInfo.setFullName(data.getString("FullName"));
        }
        if (data.has("Password")) {
            userInfo.setProperty("Password", data.getString("Password"));
        }
        if (data.has("Email")) {
            userInfo.setProperty("Email", data.getString("Email"));
        }
        if (data.has("OAuth")) {
            userInfo.setProperty("OAuth", data.getString("OAuth"));
        }
        if (data.has("OpenId")) {
            userInfo.setProperty("OpenId", data.getString("OpenId"));
        }
        try {
            OrionConfiguration.getMetaStore().updateUser(userInfo);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        if (userInfo.getProperty("EmailConfirmationId") != null && !userInfo.getProperty("EmailConfirmationId").equals(emailConfirmationid)) {
            try {
                UserEmailUtil.getUtil().sendEmailConfirmation(req, userInfo);
                return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(1, 200, "Confirmation email has been sent to " + userInfo.getProperty("Email"), null));
            }
            catch (Exception e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Error while sending email" + (e.getMessage() == null ? "" : ": " + e.getMessage()) + ". See http://wiki.eclipse.org/Orion/Server_admin_guide#Email_configuration for email configuration guide."));
                return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "Could not send confirmation email to " + userInfo.getProperty("Email"), null));
            }
        }
        return true;
    }

    private boolean handleUserReset(HttpServletRequest req, HttpServletResponse resp, String username, JSONObject json) throws ServletException, JSONException {
        String password = json.getString("Password");
        if (username == null || username.length() == 0) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, "User name not specified.", null));
        }
        UserInfo userInfo = null;
        try {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", username, false, false);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        if (userInfo == null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 404, "User " + username + " could not be found.", null));
        }
        String passwordMsg = this.validatePassword(password);
        if (passwordMsg != null) {
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, passwordMsg, null));
        }
        try {
            userInfo.setProperty("Password", password);
            OrionConfiguration.getMetaStore().updateUser(userInfo);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        return true;
    }

    private boolean handleUsersGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, JSONException, CoreException {
        List<String> users = this.getAllUsers();
        String startParam = req.getParameter(START);
        String rowsParam = req.getParameter(ROWS);
        int start = 0;
        int rows = 0;
        int count = 0;
        if (startParam != null && startParam.length() != 0) {
            start = Integer.parseInt(startParam);
            if (start < 0) {
                start = 0;
            }
        } else {
            start = 0;
        }
        if (rowsParam != null && rowsParam.length() != 0) {
            rows = Integer.parseInt(rowsParam);
            if (rows < 0) {
                rows = 20;
            }
        } else {
            rows = 20;
        }
        ArrayList<JSONObject> userJSONs = new ArrayList<JSONObject>();
        URI location = ServletResourceHandler.getURI(req);
        for (String userId : users) {
            if (count >= start + rows) break;
            if (count++ < start) continue;
            URI userLocation = URIUtil.append((URI)location, (String)userId);
            UserInfo userInfo = OrionConfiguration.getMetaStore().readUser(userId);
            userJSONs.add(this.formJson(userInfo, userLocation, req.getContextPath()));
        }
        JSONObject json = new JSONObject();
        json.put(USERS, userJSONs);
        json.put(USERS_START, start);
        json.put(USERS_ROWS, rows);
        json.put(USERS_LENGTH, users.size());
        OrionServlet.writeJSONResponse(req, resp, json);
        return true;
    }

    private boolean isAdmin(String user) {
        String creators = PreferenceHelper.getString((String)"orion.auth.user.creation", null);
        if (creators != null) {
            String[] admins;
            String[] stringArray = admins = creators.split(",");
            int n = admins.length;
            int n2 = 0;
            while (n2 < n) {
                String admin = stringArray[n2];
                if (admin.equals(user)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String validateLogin(String login) {
        if (login == null || login.length() == 0) {
            return "User login not specified";
        }
        String passwordVerificationDisabled = PreferenceHelper.getString((String)"orion.auth.disable.account.rules", (String)"false").toLowerCase();
        if ("false".equals(passwordVerificationDisabled)) {
            int length = login.length();
            if (length < 3) {
                return NLS.bind((String)"Username must contain at least {0} characters", (Object)3);
            }
            if (length > 20) {
                return NLS.bind((String)"Username must contain no more than {0} characters", (Object)20);
            }
        }
        int i = 0;
        while (i < login.length()) {
            if (!Character.isLetterOrDigit(login.charAt(i))) {
                return NLS.bind((String)"Username {0} contains invalid character ''{1}''", (Object)login, (Object)Character.valueOf(login.charAt(i)));
            }
            ++i;
        }
        return null;
    }

    private String validatePassword(String password) {
        if (password == null || password.length() == 0) {
            return "Password not specified.";
        }
        String passwordVerificationDisabled = PreferenceHelper.getString((String)"orion.auth.disable.account.rules", (String)"false").toLowerCase();
        if ("false".equals(passwordVerificationDisabled)) {
            if (password.length() < 8) {
                return NLS.bind((String)"Password must be at least {0} characters long", (Object)8);
            }
            if (Pattern.matches("[a-zA-Z]+", password) || Pattern.matches("[^a-zA-Z]+", password)) {
                return "Password must contain at least one alpha character and one non alpha character";
            }
        }
        return null;
    }
}

