/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.core.tasks.TaskDescription;
import org.eclipse.orion.internal.server.core.tasks.TaskStore;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.core.tasks.CorruptedTaskException;
import org.eclipse.orion.server.core.tasks.ITaskCanceller;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskDoesNotExistException;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.core.tasks.TaskOperationException;

public class TaskService
implements ITaskService {
    private TaskStore store;
    private Timer timer;
    private static long TEMP_TASK_LIFE = 900000L;
    private Map<TaskDescription, ITaskCanceller> taskCancellers = new HashMap<TaskDescription, ITaskCanceller>();

    public TaskService(IPath baseLocation) {
        this.store = new TaskStore(baseLocation.toFile());
        this.timer = new Timer();
        this.cleanUpTasks();
    }

    private void cleanUpTasks() {
        this.store.removeAllTempTasks();
        List<TaskDescription> allTasks = this.store.readAllTasks();
        for (TaskDescription taskDescription : allTasks) {
            try {
                TaskInfo task = TaskInfo.fromJSON(taskDescription, this.store.readTask(taskDescription));
                if (task == null) continue;
                if (task.isRunning()) {
                    task.done((IStatus)new ServerStatus(4, 500, "Task could not be completed due to server restart", null));
                    this.updateTask(task);
                    continue;
                }
                if (task.getExpires() == null) continue;
                this.timer.schedule((TimerTask)new RemoveTask(taskDescription, this), new Date(task.getExpires()));
            }
            catch (CorruptedTaskException e) {
                LogHelper.log(e);
                this.store.removeTask(taskDescription);
            }
        }
    }

    private TaskInfo internalRemoveTask(String userId, String id, boolean keep, Date dateRemoved) throws TaskOperationException {
        TaskInfo task = this.getTask(userId, id, keep);
        if (task == null) {
            throw new TaskDoesNotExistException(id);
        }
        if (task.isRunning()) {
            throw new TaskOperationException("Cannot remove a task that is running. Try to cancel first");
        }
        if (!this.store.removeTask(new TaskDescription(userId, id, keep))) {
            throw new TaskOperationException("Task could not be removed");
        }
        return task;
    }

    @Override
    public void removeTask(String userId, String id, boolean keep) throws TaskOperationException {
        Date date = new Date();
        this.internalRemoveTask(userId, id, keep, date);
    }

    @Override
    public void removeCompletedTasks(String userId) {
        Date date = new Date();
        for (TaskInfo task : this.getTasks(userId)) {
            if (task.isRunning()) continue;
            try {
                this.internalRemoveTask(userId, task.getId(), task.isKeep(), date);
            }
            catch (TaskOperationException e) {
                LogHelper.log(e);
            }
        }
    }

    @Override
    public TaskInfo createTask(String userId, boolean keep) {
        TaskInfo task = new TaskInfo(userId, new UniversalUniqueIdentifier().toBase64String(), keep);
        this.store.writeTask(new TaskDescription(userId, task.getId(), keep), task.toJSON().toString());
        return task;
    }

    @Override
    public TaskInfo getTask(String userId, String id, boolean keep) {
        TaskDescription taskDescr = new TaskDescription(userId, id, keep);
        String taskString = this.store.readTask(taskDescr);
        if (taskString == null) {
            return null;
        }
        try {
            TaskInfo info = TaskInfo.fromJSON(taskDescr, taskString);
            if (this.taskCancellers.containsKey(taskDescr)) {
                info.setCancelable(true);
            }
            return info;
        }
        catch (CorruptedTaskException e) {
            LogHelper.log(e);
            this.store.removeTask(new TaskDescription(userId, id, keep));
            return null;
        }
    }

    @Override
    public void updateTask(TaskInfo task) {
        TaskDescription taskDescription = new TaskDescription(task.getUserId(), task.getId(), task.isKeep());
        this.store.writeTask(taskDescription, task.toJSON().toString());
        if (!task.isRunning()) {
            if (task.isKeep()) {
                if (task.getExpires() != null) {
                    this.timer.schedule((TimerTask)new RemoveTask(taskDescription, this), new Date(task.getExpires()));
                }
            } else {
                this.timer.schedule((TimerTask)new RemoveTask(taskDescription, this), TEMP_TASK_LIFE);
            }
            this.taskCancellers.remove(taskDescription);
        }
    }

    @Override
    public List<TaskInfo> getTasks(String userId) {
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        for (TaskDescription taskDescr : this.store.readAllTasks(userId)) {
            try {
                String taskString = this.store.readTask(taskDescr);
                if (taskString == null) continue;
                TaskInfo info = TaskInfo.fromJSON(taskDescr, taskString);
                if (this.taskCancellers.containsKey(taskDescr)) {
                    info.setCancelable(true);
                }
                tasks.add(info);
            }
            catch (CorruptedTaskException e) {
                LogHelper.log(e);
                this.store.removeTask(taskDescr);
            }
        }
        return tasks;
    }

    @Override
    public synchronized TaskInfo createTask(String userId, boolean keep, ITaskCanceller taskCanceller) {
        TaskInfo info = this.createTask(userId, keep);
        this.taskCancellers.put(new TaskDescription(info.getUserId(), info.getId(), info.isKeep()), taskCanceller);
        info.setCancelable(true);
        return info;
    }

    @Override
    public synchronized void cancelTask(String userId, String id, boolean keep) throws TaskOperationException {
        TaskDescription taskDescription = new TaskDescription(userId, id, keep);
        ITaskCanceller taskCanceller = this.taskCancellers.get(taskDescription);
        if (taskCanceller == null) {
            TaskInfo task = this.getTask(userId, id, keep);
            if (task == null || !task.isRunning()) {
                return;
            }
            throw new TaskOperationException("Task does not support cancelling");
        }
        if (!taskCanceller.cancelTask()) {
            throw new TaskOperationException("Cancelling task failed");
        }
        TaskInfo task = this.getTask(userId, id, keep);
        task.setStatus(TaskInfo.TaskStatus.ABORT);
        this.updateTask(task);
        this.taskCancellers.remove(taskDescription);
    }

    private class RemoveTask
    extends TimerTask {
        private TaskDescription taskDescription;
        private ITaskService taskService;

        public RemoveTask(TaskDescription taskDescription, ITaskService taskService2) {
            this.taskDescription = taskDescription;
            this.taskService = taskService2;
        }

        @Override
        public void run() {
            try {
                this.taskService.removeTask(this.taskDescription.getUserId(), this.taskDescription.getTaskId(), this.taskDescription.isKeep());
            }
            catch (TaskDoesNotExistException taskDoesNotExistException) {
            }
            catch (TaskOperationException e) {
                LogHelper.log(e);
            }
        }
    }
}

