/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableHelper;
import org.eclipse.core.runtime.Assert;

public class DetailObservableList<M, E>
extends ObservableList<E>
implements IObserving {
    private final boolean updating = false;
    private IListChangeListener<E> innerChangeListener = event -> this.fireListChange(Diffs.unmodifiableDiff(event.diff));
    private M currentOuterValue;
    private IObservableList<E> innerObservableList;
    private IObservableFactory<? super M, IObservableList<E>> factory;
    private IObservableValue<M> outerObservableValue;
    private final Object detailType;
    IValueChangeListener<M> outerChangeListener = event -> {
        if (this.isDisposed()) {
            return;
        }
        ObservableTracker.setIgnore(true);
        try {
            ArrayList oldList = new ArrayList(this.wrappedList);
            this.updateInnerObservableList();
            this.fireListChange(Diffs.computeListDiff(oldList, this.wrappedList));
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    };

    public DetailObservableList(IObservableFactory<? super M, IObservableList<E>> factory, IObservableValue<M> outerObservableValue, Object detailType) {
        super(outerObservableValue.getRealm(), Collections.emptyList(), detailType);
        Assert.isTrue((!outerObservableValue.isDisposed() ? 1 : 0) != 0, (String)"Master observable is disposed");
        this.factory = factory;
        this.outerObservableValue = outerObservableValue;
        this.detailType = detailType;
        outerObservableValue.addDisposeListener(staleEvent -> this.dispose());
        ObservableTracker.setIgnore(true);
        try {
            this.updateInnerObservableList();
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableList() {
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        this.currentOuterValue = this.outerObservableValue.getValue();
        if (this.currentOuterValue == null) {
            this.innerObservableList = null;
            this.wrappedList = Collections.emptyList();
        } else {
            ObservableTracker.setIgnore(true);
            try {
                this.innerObservableList = this.factory.createObservable(this.currentOuterValue);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
            DetailObservableHelper.warnIfDifferentRealms(this.getRealm(), this.innerObservableList.getRealm());
            this.wrappedList = this.innerObservableList;
            if (this.detailType != null) {
                Object innerValueType = this.innerObservableList.getElementType();
                Assert.isTrue((boolean)this.getElementType().equals(innerValueType), (String)"Cannot change value type in a nested observable list");
            }
            this.innerObservableList.addListChangeListener(this.innerChangeListener);
        }
    }

    @Override
    public boolean add(E o) {
        ObservableTracker.setIgnore(true);
        try {
            boolean bl = this.wrappedList.add(o);
            return bl;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public void add(int index, E element) {
        ObservableTracker.setIgnore(true);
        try {
            this.wrappedList.add(index, element);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public boolean remove(Object o) {
        ObservableTracker.setIgnore(true);
        try {
            boolean bl = this.wrappedList.remove(o);
            return bl;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public E set(int index, E element) {
        ObservableTracker.setIgnore(true);
        try {
            E e = this.wrappedList.set(index, element);
            return e;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        if (this.innerObservableList != null) {
            ObservableTracker.setIgnore(true);
            try {
                E e = this.innerObservableList.move(oldIndex, newIndex);
                return e;
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
        }
        return super.move(oldIndex, newIndex);
    }

    @Override
    public E remove(int index) {
        ObservableTracker.setIgnore(true);
        try {
            Object e = this.wrappedList.remove(index);
            return e;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        ObservableTracker.setIgnore(true);
        try {
            boolean bl = this.wrappedList.addAll(c);
            return bl;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ObservableTracker.setIgnore(true);
        try {
            boolean bl = this.wrappedList.addAll(index, c);
            return bl;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ObservableTracker.setIgnore(true);
        try {
            boolean bl = this.wrappedList.removeAll(c);
            return bl;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ObservableTracker.setIgnore(true);
        try {
            boolean bl = this.wrappedList.retainAll(c);
            return bl;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public void clear() {
        ObservableTracker.setIgnore(true);
        try {
            this.wrappedList.clear();
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
        }
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        this.outerObservableValue = null;
        this.outerChangeListener = null;
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableList = null;
        this.innerChangeListener = null;
    }

    @Override
    public Object getObserved() {
        if (this.innerObservableList instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableList)).getObserved();
        }
        return null;
    }
}

