/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.dnd.GdkContentDeserializer;
import org.eclipse.swt.dnd.GdkContentSerializer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.GAsyncReadyCallbackHelper;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk4.GTK4;

class ContentProviders {
    private static ContentProviders instance = new ContentProviders();
    private final Map<Integer, String> ID_TO_CONTENTTYPE = new TreeMap<Integer, String>();
    private final Map<String, Integer> CONTENTTYPE_TO_ID = new TreeMap<String, Integer>();
    private int typeIndex = 1;
    private final Map<Long, Object> deserializedData = new HashMap<Long, Object>();
    private long nextDeserializedDataId = 100L;
    private Callback gdkContentSerializeFunc;
    private Callback gdkContentDeserializeFunc;
    private Map<String, Transfer> registeredTransfers = new TreeMap<String, Transfer>();
    private Map<String, Long> registeredTransferGtypes = new TreeMap<String, Long>();

    private ContentProviders() {
        this.gdkContentSerializeFunc = new Callback((Object)this, "gdkContentSerializeFunc", Void.TYPE, new Type[]{Long.TYPE});
        this.gdkContentDeserializeFunc = new Callback((Object)this, "gdkContentDeserializeFunc", Void.TYPE, new Type[]{Long.TYPE});
    }

    public static ContentProviders getInstance() {
        return instance;
    }

    public int registerType(String formatName) {
        if (formatName == null) {
            return 0;
        }
        Integer id = this.CONTENTTYPE_TO_ID.get(formatName);
        if (id == null) {
            id = this.typeIndex++;
            this.CONTENTTYPE_TO_ID.put(formatName, id);
            this.ID_TO_CONTENTTYPE.put(id, formatName);
        }
        return id;
    }

    public long createContentProviders(Object[] data, Transfer[] transfers, CLIPBOARD_DATA id) {
        long providers;
        id.clear();
        long[] providerList = new long[transfers.length];
        int i = 0;
        while (i < transfers.length) {
            Transfer transfer = transfers[i];
            long gType = this.getGType(transfer);
            long gvalue = OS.content_providers_create_gvalue(gType, id.sourceId);
            providerList[i] = GTK4.gdk_content_provider_new_for_value(gvalue);
            OS.g_value_unset(gvalue);
            OS.g_free(gvalue);
            id.data.put(this.transferKey(transfer), data[i]);
            ++i;
        }
        id.providers = providers = GTK4.gdk_content_provider_new_union(providerList, providerList.length);
        return providers;
    }

    private void gdkContentSerializeFunc(long pSerializer) {
        final GdkContentSerializer serializer = new GdkContentSerializer(pSerializer);
        Transfer transfer = this.getTransfer(serializer.gtype());
        final TransferData transferData = new TransferData();
        transferData.type = this.getTypeId(serializer.mime_type());
        long sourceId = OS.g_value_get_boxed(serializer.gvalue());
        CLIPBOARD_DATA clipboardData = CLIPBOARD_DATA.fromSourceId(sourceId);
        if (transferData.type == 0L || transfer == null || clipboardData == null) {
            serializer.return_error(OS.g_error_new_literal(OS.g_io_error_quark(), 0, "Could not convert data"));
            return;
        }
        Object object = clipboardData.data.get(this.transferKey(transfer));
        transfer.javaToNative(object, transferData);
        if (transferData.result != 1) {
            serializer.return_error(OS.g_error_new_literal(OS.g_io_error_quark(), 0, "Transfer object could not convert data"));
            return;
        }
        GAsyncReadyCallbackHelper.run(new GAsyncReadyCallbackHelper.Async(){

            @Override
            public void async(long callback) {
                OS.g_output_stream_write_all_async(serializer.output_stream(), transferData.pValue, transferData.length, serializer.priority(), serializer.cancellable(), callback, 0L);
            }

            @Override
            public void callback(long result) {
                long[] error = new long[1];
                boolean finish = OS.g_output_stream_write_all_finish(serializer.output_stream(), result, null, error);
                if (!finish) {
                    serializer.return_error(error[0]);
                } else {
                    serializer.return_success();
                }
                OS.g_free(transferData.pValue);
            }
        });
    }

    private void gdkContentDeserializeFunc(long pDeserializer) {
        final GdkContentDeserializer deserializer = new GdkContentDeserializer(pDeserializer);
        final Transfer transfer = this.getTransfer(deserializer.gtype());
        final TransferData transferData = new TransferData();
        transferData.type = this.getTypeId(deserializer.mime_type());
        if (transferData.type == 0L || transfer == null) {
            deserializer.return_error(OS.g_error_new_literal(OS.g_io_error_quark(), 0, "Could not convert data"));
        }
        final long memoryStream = OS.g_memory_output_stream_new_resizable();
        GAsyncReadyCallbackHelper.run(new GAsyncReadyCallbackHelper.Async(){

            @Override
            public void async(long callback) {
                OS.g_output_stream_splice_async(memoryStream, deserializer.input_stream(), 3, deserializer.priority(), deserializer.cancellable(), callback, 0L);
            }

            @Override
            public void callback(long result) {
                long[] error = new long[1];
                long size = OS.g_output_stream_splice_finish(memoryStream, result, null);
                if (size < 0L) {
                    deserializer.return_error(error[0]);
                    return;
                }
                if (size > Integer.MAX_VALUE) {
                    deserializer.return_error(OS.g_error_new_literal(OS.g_io_error_quark(), 46, "Could not convert data because transfer size was too big " + size));
                    return;
                }
                transferData.length = (int)size;
                transferData.pValue = OS.g_memory_output_stream_get_data(memoryStream);
                transferData.format = 8;
                Object data = transfer.nativeToJava(transferData);
                OS.g_object_unref(memoryStream);
                long gvalue = deserializer.get_value();
                long deserializedDataId = ContentProviders.this.nextDeserializedDataId++;
                OS.g_value_take_boxed(gvalue, deserializedDataId);
                ContentProviders.this.deserializedData.put(deserializedDataId, data);
                deserializer.return_success();
            }
        });
    }

    private int getTypeId(String mime_type) {
        Integer typeObject = this.CONTENTTYPE_TO_ID.get(mime_type);
        return typeObject == null ? 0 : typeObject;
    }

    private Transfer getTransfer(long gtype) {
        long g_type_name = OS.g_type_name(gtype);
        if (g_type_name == 0L) {
            return null;
        }
        String transferKey = Converter.cCharPtrToJavaString(g_type_name, false);
        return this.registeredTransfers.get(transferKey);
    }

    private String transferKey(Transfer transfer) {
        String lowerCaseSafeClassName = transfer.getClass().getSimpleName().replaceAll("[^A-Za-z0-9_]", "_");
        return "SwtTransfer_" + lowerCaseSafeClassName + "_" + transfer.id;
    }

    private void registerTransfer(Transfer transfer) {
        String name = this.transferKey(transfer);
        if (this.registeredTransfers.containsKey(name)) {
            return;
        }
        this.registeredTransfers.put(name, transfer);
        long gtype = OS.content_providers_create_gtype(name);
        this.registeredTransferGtypes.put(name, gtype);
        String[] mimeTypes = transfer.getTypeNames();
        int i = 0;
        while (i < mimeTypes.length) {
            String mimeType = mimeTypes[i];
            GTK4.gdk_content_register_serializer(gtype, mimeType, this.gdkContentSerializeFunc.getAddress(), 0L, 0L);
            GTK4.gdk_content_register_deserializer(mimeType, gtype, this.gdkContentDeserializeFunc.getAddress(), 0L, 0L);
            ++i;
        }
    }

    public long getGType(Transfer transfer) {
        this.registerTransfer(transfer);
        return this.registeredTransferGtypes.get(this.transferKey(transfer));
    }

    public Object getObject(long gvalue) {
        if (gvalue == 0L) {
            return null;
        }
        long namePtr = OS.G_VALUE_TYPE_NAME(gvalue);
        String transferName = Converter.cCharPtrToJavaString(namePtr, false);
        Transfer transfer = this.registeredTransfers.get(transferName);
        if (transfer != null) {
            long g_value_get_boxed = OS.g_value_get_boxed(gvalue);
            CLIPBOARD_DATA fromSourceId = CLIPBOARD_DATA.fromSourceId(g_value_get_boxed);
            if (fromSourceId != null) {
                return fromSourceId.data.get(this.transferKey(transfer));
            }
            return this.deserializedData.remove(g_value_get_boxed);
        }
        return null;
    }

    public static enum CLIPBOARD_DATA {
        CLIPBOARD(1L),
        PRIMARYCLIPBOARD(2L),
        DRAG(3L);

        private final long sourceId;
        private final Map<String, Object> data = new HashMap<String, Object>();
        private long providers = 0L;

        private CLIPBOARD_DATA(long id) {
            this.sourceId = id;
        }

        public static CLIPBOARD_DATA fromDNDConstants(int clipboards) {
            if (clipboards == 1) {
                return CLIPBOARD;
            }
            if (clipboards == 2) {
                return PRIMARYCLIPBOARD;
            }
            throw new UnsupportedOperationException("Error - invalid clipboards");
        }

        public static CLIPBOARD_DATA fromSourceId(long sourceId) {
            CLIPBOARD_DATA[] values;
            CLIPBOARD_DATA[] cLIPBOARD_DATAArray = values = CLIPBOARD_DATA.values();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                CLIPBOARD_DATA d = cLIPBOARD_DATAArray[n2];
                if (d.sourceId == sourceId) {
                    return d;
                }
                ++n2;
            }
            return null;
        }

        void clear() {
            this.data.clear();
            if (this.providers != 0L) {
                OS.g_object_unref(this.providers);
                this.providers = 0L;
            }
        }
    }
}

