/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.win32.version;

import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.internal.win32.version.OSVERSIONINFOEX;

public class OsVersion
extends Platform {
    private static final int WIN32_BUILD;
    private static final int WIN10_1607 = 14393;
    public static final boolean IS_WIN10_1607;
    public static final boolean IS_WIN10_1809;
    public static final boolean IS_WIN10_2004;
    public static final boolean IS_WIN11_21H2;
    private static final int MINIMUM_COMPATIBLE_BUILD = 14393;
    private static final String DISABLE_WINDOWS_VERSION_CHECK_PROPERTY = "swt.disableWindowsVersionCheck";

    static {
        Library.loadLibrary("swt-osversion");
        WIN32_BUILD = OsVersion.getCurrentOsVersion();
        IS_WIN10_1607 = WIN32_BUILD >= 14393;
        IS_WIN10_1809 = WIN32_BUILD >= 17763;
        IS_WIN10_2004 = WIN32_BUILD >= 19041;
        IS_WIN11_21H2 = WIN32_BUILD >= 22000;
    }

    private static int getCurrentOsVersion() {
        OSVERSIONINFOEX osVersionInfoEx = new OSVERSIONINFOEX();
        osVersionInfoEx.dwOSVersionInfoSize = OSVERSIONINFOEX.sizeof;
        if (OsVersion.RtlGetVersion(osVersionInfoEx) == 0) {
            return osVersionInfoEx.dwBuildNumber;
        }
        System.err.println("SWT: OS: Failed to detect Windows build number");
        return 0;
    }

    public static void checkCompatibleWindowsVersion() {
        boolean versionCheckDisabled;
        String disableVersionCheckPropertyValue = System.getProperty(DISABLE_WINDOWS_VERSION_CHECK_PROPERTY, Boolean.FALSE.toString());
        boolean bl = versionCheckDisabled = "".equals(disableVersionCheckPropertyValue) || Boolean.TRUE.toString().equalsIgnoreCase(disableVersionCheckPropertyValue);
        if (!versionCheckDisabled && WIN32_BUILD < 14393) {
            System.err.println(String.format("Incompatible OS: Minimum Windows build version is %s but current is %s", 14393, WIN32_BUILD));
            System.exit(1);
        }
    }

    public static final native int OSVERSIONINFOEX_sizeof();

    public static final native int RtlGetVersion(OSVERSIONINFOEX var0);
}

