/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObservableListContentProvider<E>
implements IStructuredContentProvider {
    private ObservableCollectionContentProvider<E> impl;

    public ObservableListContentProvider() {
        this(null);
    }

    public ObservableListContentProvider(IViewerUpdater<E> viewerUpdater) {
        this.impl = new Impl<E>(viewerUpdater);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet<E> getKnownElements() {
        return this.impl.getKnownElements();
    }

    public IObservableSet<E> getRealizedElements() {
        return this.impl.getRealizedElements();
    }

    private static class Impl<E>
    extends ObservableCollectionContentProvider<E>
    implements IListChangeListener<E> {
        private Viewer viewer;

        Impl(IViewerUpdater<E> explicitViewerUpdater) {
            super(explicitViewerUpdater);
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }

        @Override
        protected void checkInput(Object input) {
            Assert.isTrue((boolean)(input instanceof IObservableList), (String)"This content provider only works with input of type IObservableList");
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection<E> collection) {
            ((IObservableList)collection).addListChangeListener((IListChangeListener)this);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection<E> collection) {
            ((IObservableList)collection).removeListChangeListener((IListChangeListener)this);
        }

        public void handleListChange(ListChangeEvent<? extends E> event) {
            if (this.isViewerDisposed()) {
                return;
            }
            final Set knownElementAdditions = ViewerElementSet.withComparer(this.comparer);
            final Set knownElementRemovals = ViewerElementSet.withComparer(this.comparer);
            final boolean[] suspendRedraw = new boolean[1];
            event.diff.accept(new ListDiffVisitor<E>(){

                public void handleAdd(int index, E element) {
                    knownElementAdditions.add(element);
                }

                public void handleRemove(int index, E element) {
                    knownElementRemovals.add(element);
                }

                public void handleMove(int oldIndex, int newIndex, E element) {
                    suspendRedraw[0] = true;
                    super.handleMove(oldIndex, newIndex, element);
                }

                public void handleReplace(int index, E oldElement, E newElement) {
                    suspendRedraw[0] = true;
                    super.handleReplace(index, oldElement, newElement);
                }
            });
            knownElementAdditions.removeAll((Collection<?>)this.knownElements);
            knownElementRemovals.removeAll((Collection<?>)event.getObservableList());
            this.knownElements.addAll(knownElementAdditions);
            if (this.realizedElements != null) {
                this.realizedElements.removeAll(knownElementRemovals);
            }
            if (suspendRedraw[0]) {
                this.viewer.getControl().setRedraw(false);
            }
            try {
                event.diff.accept(new ListDiffVisitor<E>(){

                    public void handleAdd(int index, E element) {
                        viewerUpdater.insert(element, index);
                    }

                    public void handleRemove(int index, E element) {
                        viewerUpdater.remove(element, index);
                    }

                    public void handleReplace(int index, E oldElement, E newElement) {
                        viewerUpdater.replace(oldElement, newElement, index);
                    }

                    public void handleMove(int oldIndex, int newIndex, E element) {
                        viewerUpdater.move(element, oldIndex, newIndex);
                    }
                });
            }
            finally {
                if (suspendRedraw[0]) {
                    this.viewer.getControl().setRedraw(true);
                }
            }
            if (this.realizedElements != null) {
                this.realizedElements.addAll(knownElementAdditions);
            }
            this.knownElements.removeAll(knownElementRemovals);
        }
    }
}

