/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.internal.util.Util;

public final class ActivityManagerEvent {
    private IActivityManager activityManager;
    private boolean definedActivityIdsChanged;
    private boolean definedCategoryIdsChanged;
    private boolean enabledActivityIdsChanged;
    private Boolean enabledNonExpressionControlledActivityIdsChanged = null;
    private final Set<String> previouslyDefinedActivityIds;
    private final Set<String> previouslyDefinedCategoryIds;
    private final Set<String> previouslyEnabledActivityIds;

    public ActivityManagerEvent(IActivityManager activityManager, boolean definedActivityIdsChanged, boolean definedCategoryIdsChanged, boolean enabledActivityIdsChanged, Set<String> previouslyDefinedActivityIds, Set<String> previouslyDefinedCategoryIds, Set<String> previouslyEnabledActivityIds) {
        if (activityManager == null) {
            throw new NullPointerException();
        }
        if (!definedActivityIdsChanged && previouslyDefinedActivityIds != null) {
            throw new IllegalArgumentException();
        }
        if (!definedCategoryIdsChanged && previouslyDefinedCategoryIds != null) {
            throw new IllegalArgumentException();
        }
        if (!enabledActivityIdsChanged && previouslyEnabledActivityIds != null) {
            throw new IllegalArgumentException();
        }
        this.previouslyDefinedActivityIds = definedActivityIdsChanged ? Util.safeCopy(previouslyDefinedActivityIds, String.class) : null;
        this.previouslyDefinedCategoryIds = definedCategoryIdsChanged ? Util.safeCopy(previouslyDefinedCategoryIds, String.class) : null;
        this.previouslyEnabledActivityIds = enabledActivityIdsChanged ? Util.safeCopy(previouslyEnabledActivityIds, String.class) : null;
        this.activityManager = activityManager;
        this.definedActivityIdsChanged = definedActivityIdsChanged;
        this.definedCategoryIdsChanged = definedCategoryIdsChanged;
        this.enabledActivityIdsChanged = enabledActivityIdsChanged;
    }

    public ActivityManagerEvent(IActivityManager activityManager, boolean definedActivityIdsChanged, boolean definedCategoryIdsChanged, boolean enabledActivityIdsChanged, Set<String> previouslyDefinedActivityIds, Set<String> previouslyDefinedCategoryIds, Set<String> previouslyEnabledActivityIds, Set<String> changedEnabledActivityIds) {
        this(activityManager, definedActivityIdsChanged, definedCategoryIdsChanged, enabledActivityIdsChanged, previouslyDefinedActivityIds, previouslyDefinedCategoryIds, previouslyEnabledActivityIds);
        this.enabledNonExpressionControlledActivityIdsChanged = enabledActivityIdsChanged ? Boolean.valueOf(changedEnabledActivityIds.stream().anyMatch(this::isIdOfNonExpressionControlledActivity)) : Boolean.valueOf(false);
    }

    public ActivityManagerEvent copyFor(IActivityManager newActivityManager) {
        ActivityManagerEvent copy = new ActivityManagerEvent(newActivityManager, this.definedActivityIdsChanged, this.definedCategoryIdsChanged, this.enabledActivityIdsChanged, this.previouslyDefinedActivityIds, this.previouslyDefinedCategoryIds, this.previouslyEnabledActivityIds);
        copy.enabledNonExpressionControlledActivityIdsChanged = this.enabledNonExpressionControlledActivityIdsChanged;
        return copy;
    }

    public IActivityManager getActivityManager() {
        return this.activityManager;
    }

    public Set<String> getPreviouslyDefinedActivityIds() {
        return this.previouslyDefinedActivityIds;
    }

    public Set<String> getPreviouslyDefinedCategoryIds() {
        return this.previouslyDefinedCategoryIds;
    }

    public Set<String> getPreviouslyEnabledActivityIds() {
        return this.previouslyEnabledActivityIds;
    }

    public boolean haveDefinedActivityIdsChanged() {
        return this.definedActivityIdsChanged;
    }

    public boolean haveDefinedCategoryIdsChanged() {
        return this.definedCategoryIdsChanged;
    }

    public boolean haveEnabledActivityIdsChanged() {
        return this.enabledActivityIdsChanged;
    }

    public boolean haveEnabledNonExpressionControlledActivityIdsChanged() {
        if (this.enabledNonExpressionControlledActivityIdsChanged == null) {
            this.enabledNonExpressionControlledActivityIdsChanged = this.calculateHaveEnabledNonExpressionControlledActivityIdsChanged();
        }
        return this.enabledNonExpressionControlledActivityIdsChanged;
    }

    private boolean calculateHaveEnabledNonExpressionControlledActivityIdsChanged() {
        Set<Object> previousIds = this.previouslyEnabledActivityIds == null ? Collections.emptySet() : this.previouslyEnabledActivityIds;
        Set<String> currentIds = this.activityManager.getEnabledActivityIds();
        Stream<String> addedIds = currentIds.stream().filter(id -> !previousIds.contains(id));
        if (addedIds.anyMatch(this::isIdOfNonExpressionControlledActivity)) {
            return true;
        }
        Stream<String> removedIds = previousIds.stream().filter(id -> !currentIds.contains(id));
        return removedIds.anyMatch(this::isIdOfNonExpressionControlledActivity);
    }

    private boolean isIdOfNonExpressionControlledActivity(String id) {
        return this.activityManager.getActivity(id).getExpression() == null;
    }
}

