/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import org.eclipse.e4.ui.css.core.dom.CSSPropertyList;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.impl.dom.CSSRuleImpl;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSStyleRuleImpl
extends CSSRuleImpl
implements CSSStyleRule,
ExtendedCSSRule {
    private SelectorList selectors;
    private CSSStyleDeclaration styleDeclaration;

    public CSSStyleRuleImpl(CSSStyleSheet parentStyleSheet, CSSRule parentRule, SelectorList selectors) {
        super(parentStyleSheet, parentRule);
        this.selectors = selectors;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public String getCssText() {
        return this.getSelectorText() + " { " + this.getStyle().getCssText() + " }";
    }

    @Override
    public String getSelectorText() {
        StringBuilder sb = new StringBuilder();
        int selID = 0;
        while (selID < this.getSelectorList().getLength()) {
            Selector item = this.getSelectorList().item(selID);
            sb.append(item.toString());
            sb.append(", ");
            ++selID;
        }
        if (this.getSelectorList().getLength() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        return this.styleDeclaration;
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    @Override
    public SelectorList getSelectorList() {
        return this.selectors;
    }

    @Override
    public CSSPropertyList getCSSPropertyList() {
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    public void setStyle(CSSStyleDeclaration styleDeclaration) {
        this.styleDeclaration = styleDeclaration;
    }

    public String toString() {
        return this.getSelectorText();
    }
}

