/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.core.text.StringMatcher;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.actions.PropertyDialogAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class IUDetailsGroup {
    private static final String LINKACTION = "linkAction";
    private GridLayout layout;
    private StyledText detailsArea;
    private GridData gd;
    private Link propLink;
    private final ISelectionProvider selectionProvider;
    private final int widthHint;
    private final boolean scrollable;
    private String lastText;

    public IUDetailsGroup(Composite parent, ISelectionProvider selectionProvider, int widthHint, boolean scrollable) {
        this.selectionProvider = selectionProvider;
        this.widthHint = widthHint;
        this.scrollable = scrollable;
        this.createGroupComposite(parent);
    }

    void createGroupComposite(Composite parent) {
        Group detailsComposite = new Group(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        detailsComposite.setText(ProvUIMessages.ProfileModificationWizardPage_DetailsLabel);
        this.layout = new GridLayout();
        this.layout.marginWidth = 0;
        this.layout.marginHeight = 0;
        detailsComposite.setLayout((Layout)this.layout);
        this.gd = new GridData(4, 4, true, true);
        detailsComposite.setLayoutData((Object)this.gd);
        this.gd = new GridData(4, 4, true, true);
        this.gd.verticalIndent = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        this.gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)4);
        this.gd.minimumHeight = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        this.gd.widthHint = this.widthHint;
        this.detailsArea = this.scrollable ? new StyledText((Composite)detailsComposite, 584) : new StyledText((Composite)detailsComposite, 72);
        this.detailsArea.setLayoutData((Object)this.gd);
        this.gd = new GridData(0x1000008, 1024, true, false);
        this.gd.horizontalIndent = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)7);
        this.propLink = this.createLink((Composite)detailsComposite, (IAction)new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)parent.getShell()), this.selectionProvider), ProvUIMessages.AvailableIUsPage_GotoProperties);
        this.propLink.setLayoutData((Object)this.gd);
        this.propLink.setVisible(!this.selectionProvider.getSelection().isEmpty());
    }

    public void setDetailText(String text) {
        if (this.lastText == null || !this.lastText.equals(text)) {
            this.detailsArea.setText(text);
        }
        this.lastText = text;
    }

    public void setDetailHighlight(String pattern) {
        this.detailsArea.setStyleRanges(new StyleRange[0]);
        if (pattern != null && !pattern.isEmpty()) {
            StringMatcher matcher = new StringMatcher(pattern, true, false);
            int i = 0;
            StringMatcher.Position match = null;
            do {
                if ((match = matcher.find(this.lastText, i, this.lastText.length())) == null) continue;
                i = match.getEnd();
                this.detailsArea.setStyleRange(new StyleRange(match.getStart(), match.getEnd() - match.getStart(), null, null, 1));
            } while (match != null);
        }
    }

    public void enablePropertyLink(boolean enable) {
        this.propLink.setVisible(enable);
    }

    private Link createLink(Composite parent, IAction action, String text) {
        Link link = new Link(parent, 8);
        link.setText(text);
        link.addListener(13, event -> {
            IAction linkAction = this.getLinkAction(event.widget);
            if (linkAction != null) {
                linkAction.runWithEvent(event);
            }
        });
        link.setToolTipText(action.getToolTipText());
        link.setData(LINKACTION, (Object)action);
        return link;
    }

    IAction getLinkAction(Widget widget) {
        Object data = widget.getData(LINKACTION);
        if (data == null || !(data instanceof IAction)) {
            return null;
        }
        return (IAction)data;
    }
}

