/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.net.NetUIMessages;
import org.eclipse.ui.internal.net.ProxyEntriesContentProvider;
import org.eclipse.ui.internal.net.ProxyEntriesLabelProvider;
import org.eclipse.ui.internal.net.ProxyEntryDialog;

public class ProxyEntriesComposite
extends Composite {
    private Label entriesLabel;
    private CheckboxTableViewer entriesViewer;
    private Button editButton;
    private Button removeButton;
    protected String currentProvider;
    private final ArrayList<ProxyData> proxyEntries = new ArrayList();

    ProxyEntriesComposite(Composite parent, int style) {
        super(parent, style);
        this.createWidgets();
    }

    protected void createWidgets() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.entriesLabel = new Label((Composite)this, 0);
        this.entriesLabel.setText(NetUIMessages.ProxyPreferencePage_1);
        this.entriesLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Table entriesTable = new Table((Composite)this, 68386);
        entriesTable.setHeaderVisible(true);
        entriesTable.setLinesVisible(true);
        entriesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.entriesViewer = new CheckboxTableViewer(entriesTable);
        ProxyEntriesLabelProvider labelProvider = new ProxyEntriesLabelProvider();
        ProxyEntriesContentProvider contentProvider = new ProxyEntriesContentProvider();
        labelProvider.createColumns((TableViewer)this.entriesViewer);
        this.entriesViewer.setContentProvider((IContentProvider)contentProvider);
        this.entriesViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(24));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        entriesTable.setLayout((Layout)tableLayout);
        this.editButton = this.createButton(NetUIMessages.ProxyPreferencePage_10);
        this.removeButton = this.createButton(NetUIMessages.ProxyPreferencePage_11);
        this.entriesViewer.addSelectionChangedListener(event -> this.enableButtons());
        this.entriesViewer.addCheckStateListener(event -> this.setProvider(this.currentProvider));
        this.entriesViewer.addDoubleClickListener(event -> this.editSelection());
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyEntriesComposite.this.editSelection();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyEntriesComposite.this.removeSelection();
            }
        });
        this.initializeValues();
        this.enableButtons();
    }

    protected void enableButtons() {
        boolean enabled = this.getEnabled();
        if (enabled) {
            this.editButton.setEnabled(this.isSelectionEditable());
            this.removeButton.setEnabled(this.isSelectionRemovable());
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private boolean isSelectionEditable() {
        IStructuredSelection selection = this.entriesViewer.getStructuredSelection();
        return this.isSelectionRemovable() && selection.size() == 1;
    }

    private boolean isSelectionRemovable() {
        IStructuredSelection selection = this.entriesViewer.getStructuredSelection();
        Iterator iterator = selection.iterator();
        boolean editable = iterator.hasNext();
        while (iterator.hasNext()) {
            String provider = ((ProxyData)iterator.next()).getSource();
            if (ProxySelector.canSetProxyData((String)provider)) continue;
            editable = false;
        }
        return editable;
    }

    protected void addEntry() {
        Iterator<ProxyData> it = this.proxyEntries.iterator();
        ArrayList<String> added = new ArrayList<String>();
        String editableProvider = this.getEditableProvider();
        while (it.hasNext()) {
            ProxyData data = it.next();
            if (!data.getSource().equalsIgnoreCase(editableProvider)) continue;
            added.add(data.getType());
        }
        String[] addedArray = added.toArray(new String[0]);
        ProxyData data = this.promptForEntry(null, addedArray, NetUIMessages.ProxyEntryDialog_0);
        if (data != null) {
            data.setSource(editableProvider);
            this.proxyEntries.add(0, data);
            this.entriesViewer.refresh();
        }
    }

    private String getEditableProvider() {
        String[] providers;
        String[] stringArray = providers = ProxySelector.getProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            if (ProxySelector.canSetProxyData((String)provider)) {
                return provider;
            }
            ++n2;
        }
        return null;
    }

    private ProxyData promptForEntry(ProxyData entry, String[] addedArray, String title) {
        ProxyEntryDialog dialog = new ProxyEntryDialog(this.getShell(), entry, addedArray, title);
        int result = dialog.open();
        if (result != 1) {
            return dialog.getValue();
        }
        return null;
    }

    protected void editSelection() {
        if (!this.isSelectionRemovable()) {
            return;
        }
        Iterator itsel = this.entriesViewer.getStructuredSelection().iterator();
        ProxyData toEdit = null;
        if (!itsel.hasNext()) {
            return;
        }
        toEdit = (ProxyData)itsel.next();
        Iterator<ProxyData> it = this.proxyEntries.iterator();
        ArrayList<String> added = new ArrayList<String>();
        String editableProvider = this.getEditableProvider();
        while (it.hasNext()) {
            ProxyData data = it.next();
            if (!data.getSource().equalsIgnoreCase(editableProvider) || data.getType() == toEdit.getType()) continue;
            added.add(data.getType());
        }
        String[] addedArray = added.toArray(new String[0]);
        ProxyData data = this.promptForEntry(toEdit, addedArray, NetUIMessages.ProxyEntryDialog_1);
        if (data != null) {
            this.entriesViewer.refresh();
        }
    }

    protected void removeSelection() {
        IStructuredSelection selection = this.entriesViewer.getStructuredSelection();
        for (ProxyData data : selection) {
            data.setHost("");
            data.setPort(-1);
            data.setUserid(null);
            data.setPassword(null);
        }
        this.entriesViewer.refresh();
    }

    private Button createButton(String message) {
        Button button = new Button((Composite)this, 8);
        button.setText(message);
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        return button;
    }

    public void initializeValues() {
        String[] providers;
        String[] stringArray = providers = ProxySelector.getProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            this.proxyEntries.addAll(this.getProxyData(provider));
            ++n2;
        }
        this.entriesViewer.setInput(this.proxyEntries);
        this.setProvider(ProxySelector.getDefaultProvider());
    }

    public void setProvider(String item) {
        if (item == null) {
            item = this.currentProvider;
        } else {
            this.currentProvider = item;
        }
        ArrayList<ProxyData> checked = new ArrayList<ProxyData>();
        for (ProxyData data : this.proxyEntries) {
            if (!data.getSource().equalsIgnoreCase(item)) continue;
            checked.add(data);
        }
        this.entriesViewer.setCheckedElements((Object[])checked.toArray(new ProxyData[0]));
    }

    public void performApply() {
        ProxyData[] data;
        String provider = this.getEditableProvider();
        Iterator<ProxyData> it = this.proxyEntries.iterator();
        ArrayList<ProxyData[]> proxies = new ArrayList<ProxyData[]>();
        while (it.hasNext()) {
            data = it.next();
            if (!data.getSource().equals(provider)) continue;
            proxies.add(data);
        }
        data = proxies.toArray(new ProxyData[0]);
        ProxySelector.setProxyData((String)provider, (ProxyData[])data);
    }

    public void refresh() {
        String[] providers;
        String provider = this.getEditableProvider();
        Iterator<ProxyData> it = this.proxyEntries.iterator();
        ArrayList<ProxyData> natives = new ArrayList<ProxyData>();
        while (it.hasNext()) {
            ProxyData data = it.next();
            if (data.getSource().equals(provider)) continue;
            natives.add(data);
        }
        this.proxyEntries.removeAll(natives);
        String[] stringArray = providers = ProxySelector.getProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (!p.equals(provider)) {
                this.proxyEntries.addAll(this.getProxyData(p));
            }
            ++n2;
        }
        this.entriesViewer.refresh();
        this.setProvider(this.currentProvider);
    }

    private List<ProxyData> getProxyData(String provider) {
        ProxyData[] entries;
        ArrayList<ProxyData> proxyDatas = new ArrayList<ProxyData>();
        ProxyData[] proxyDataArray = entries = ProxySelector.getProxyData((String)provider);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ProxyData entry = proxyDataArray[n2];
            entry.setSource(provider);
            proxyDatas.add(entry);
            ++n2;
        }
        return proxyDatas;
    }
}

