/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.internal.text.codemining.CodeMiningDocumentFooterAnnotation;
import org.eclipse.jface.internal.text.codemining.CodeMiningLineContentAnnotation;
import org.eclipse.jface.internal.text.codemining.CodeMiningLineHeaderAnnotation;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.jface.text.source.inlined.LineFooterAnnotation;
import org.eclipse.jface.text.source.inlined.LineHeaderAnnotation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class InlinedAnnotationDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    private final ITextViewer viewer;
    private static final String INLINE_ANNOTATION_FONT = InlinedAnnotationDrawingStrategy.class.getSimpleName() + ".font";

    public InlinedAnnotationDrawingStrategy(ITextViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void draw(Annotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        if (annotation instanceof AbstractInlinedAnnotation) {
            AbstractInlinedAnnotation inlinedAnnotation = (AbstractInlinedAnnotation)annotation;
            if (textWidget != this.viewer.getTextWidget()) {
                throw new IllegalArgumentException("Text widget and Text viewer are not related!");
            }
            InlinedAnnotationSupport support = InlinedAnnotationSupport.getSupport(textWidget);
            inlinedAnnotation.setSupport(support);
            if (support.isInVisibleLines(inlinedAnnotation.getPosition().offset) && inlinedAnnotation.isFirstVisibleOffset(widgetOffset, this.viewer)) {
                GCConfig initialGCConfig = GCConfig.fromGC(gc);
                GCConfig annotationGCConfig = new GCConfig(color, textWidget.getBackground(), this.getAnnotationFont(textWidget));
                annotationGCConfig.applyTo(gc);
                InlinedAnnotationDrawingStrategy.draw(inlinedAnnotation, gc, textWidget, widgetOffset, length, color);
                initialGCConfig.applyTo(gc);
            }
        }
    }

    private Font getAnnotationFont(StyledText textWidget) {
        Font annotationFont = (Font)textWidget.getData(INLINE_ANNOTATION_FONT);
        if (!this.match(annotationFont, textWidget)) {
            if (annotationFont != null) {
                annotationFont.dispose();
            }
            annotationFont = null;
        }
        if (annotationFont == null) {
            annotationFont = this.createInlineAnnotationFont(textWidget);
            textWidget.setData(INLINE_ANNOTATION_FONT, (Object)annotationFont);
            textWidget.addDisposeListener(e -> ((Font)textWidget.getData(INLINE_ANNOTATION_FONT)).dispose());
        }
        return annotationFont;
    }

    private Font createInlineAnnotationFont(StyledText widget) {
        FontData[] fontData;
        Font initialFont = widget.getFont();
        FontData[] fontDataArray = fontData = initialFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | 2);
            ++n2;
        }
        return new Font(initialFont.getDevice(), fontData);
    }

    private boolean match(Font annotationFont, StyledText widget) {
        if (annotationFont == null) {
            return false;
        }
        int widgetFontHeight = widget.getFont().getFontData()[0].getHeight();
        int annotationFontHeight = annotationFont.getFontData()[0].getHeight();
        return annotationFontHeight == widgetFontHeight;
    }

    public static void draw(AbstractInlinedAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        if (annotation instanceof LineHeaderAnnotation) {
            LineHeaderAnnotation lha = (LineHeaderAnnotation)annotation;
            InlinedAnnotationDrawingStrategy.draw(lha, gc, textWidget, widgetOffset, length, color);
        } else if (annotation instanceof LineFooterAnnotation) {
            LineFooterAnnotation lfa = (LineFooterAnnotation)annotation;
            InlinedAnnotationDrawingStrategy.draw(lfa, gc, textWidget, widgetOffset, length, color);
        } else {
            InlinedAnnotationDrawingStrategy.draw((LineContentAnnotation)annotation, gc, textWidget, widgetOffset, length, color);
        }
    }

    private static void draw(LineHeaderAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (InlinedAnnotationDrawingStrategy.isInlinedAnnotationDeleted(textWidget, offset, annotation)) {
            return;
        }
        int line = textWidget.getLineAtOffset(offset);
        int charCount = textWidget.getCharCount();
        if (gc != null) {
            int y;
            int x;
            int height;
            if (annotation instanceof CodeMiningLineHeaderAnnotation) {
                CodeMiningLineHeaderAnnotation cmmla = (CodeMiningLineHeaderAnnotation)annotation;
                height = cmmla.getHeight(gc);
            } else {
                height = annotation.getHeight();
            }
            if (height != 0) {
                if (height != textWidget.getLineVerticalIndent(line)) {
                    if (annotation.oldLine != -1 && annotation.oldLine < textWidget.getLineCount()) {
                        textWidget.setLineVerticalIndent(annotation.oldLine, 0);
                    }
                    textWidget.setLineVerticalIndent(line, height);
                }
                annotation.oldLine = line;
            } else if (textWidget.getLineVerticalIndent(line) > 0) {
                textWidget.setLineVerticalIndent(line, 0);
            }
            if (offset < charCount) {
                Rectangle bounds = textWidget.getTextBounds(offset, offset);
                x = bounds.x;
                y = bounds.y;
            } else {
                Point locAtOff = textWidget.getLocationAtOffset(offset);
                x = locAtOff.x;
                y = locAtOff.y - height;
            }
            gc.setBackground(textWidget.getBackground());
            annotation.setLocation(x, y);
            annotation.draw(gc, textWidget, offset, length, color, x, y);
        } else if (textWidget.getLineVerticalIndent(line) > 0) {
            InlinedAnnotationDrawingStrategy.redrawLine(textWidget, offset, charCount);
        } else {
            InlinedAnnotationDrawingStrategy.redrawAll(textWidget, offset, charCount, length);
        }
    }

    private static void draw(LineFooterAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (InlinedAnnotationDrawingStrategy.isInlinedAnnotationDeleted(textWidget, offset, annotation)) {
            return;
        }
        int line = textWidget.getLineAtOffset(offset);
        int charCount = textWidget.getCharCount();
        if (gc != null) {
            int y;
            int x;
            int height = annotation instanceof CodeMiningDocumentFooterAnnotation ? 0 : annotation.getHeight();
            if (height != 0) {
                if (height != textWidget.getLineVerticalIndent(line)) {
                    textWidget.setLineVerticalIndent(line, height);
                }
            } else if (textWidget.getLineVerticalIndent(line) > 0) {
                textWidget.setLineVerticalIndent(line, 0);
            }
            if (offset < charCount) {
                Rectangle bounds = textWidget.getTextBounds(offset, offset);
                x = bounds.x;
                y = bounds.y;
            } else {
                int lineAtOffset = textWidget.getLineAtOffset(offset);
                int offsetAtBeginningOfLine = textWidget.getOffsetAtLine(lineAtOffset);
                if (offsetAtBeginningOfLine >= charCount) {
                    Point locAtOff = textWidget.getLocationAtOffset(offsetAtBeginningOfLine);
                    x = locAtOff.x;
                    y = locAtOff.y;
                } else {
                    Rectangle bounds = textWidget.getTextBounds(offsetAtBeginningOfLine, offsetAtBeginningOfLine);
                    int lineSpacing = textWidget.getLineSpacing();
                    x = bounds.x;
                    y = bounds.y + bounds.height + lineSpacing;
                }
            }
            gc.setBackground(textWidget.getBackground());
            annotation.setLocation(x, y);
            annotation.draw(gc, textWidget, offset, length, color, x, y);
        } else if (textWidget.getLineVerticalIndent(line) > 0) {
            InlinedAnnotationDrawingStrategy.redrawLine(textWidget, offset, charCount);
        } else {
            InlinedAnnotationDrawingStrategy.redrawAll(textWidget, offset, charCount, length);
        }
    }

    private static boolean isInlinedAnnotationDeleted(StyledText textWidget, int offset, AbstractInlinedAnnotation annotation) {
        int line = textWidget.getLineAtOffset(offset);
        int charCount = textWidget.getCharCount();
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation, charCount)) {
            if (textWidget.getLineVerticalIndent(line) > 0) {
                textWidget.setLineVerticalIndent(line, 0);
            }
            return true;
        }
        return false;
    }

    private static void redrawAll(StyledText textWidget, int offset, int charCount, int length) {
        if (offset >= charCount) {
            if (charCount > 0) {
                textWidget.redrawRange(charCount - 1, 1, true);
            } else {
                Rectangle client = textWidget.getClientArea();
                textWidget.redraw(0, 0, client.width, client.height, false);
            }
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }

    private static void redrawLine(StyledText textWidget, int offset, int charCount) {
        int height;
        int y;
        Rectangle client = textWidget.getClientArea();
        if (offset < charCount) {
            Rectangle bounds = textWidget.getTextBounds(offset, offset);
            y = bounds.y;
            height = bounds.height;
        } else {
            y = 0;
            height = client.height;
        }
        textWidget.redraw(0, y, client.width, height, false);
    }

    private static void draw(LineContentAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        CodeMiningLineContentAnnotation a;
        if (annotation instanceof CodeMiningLineContentAnnotation && (a = (CodeMiningLineContentAnnotation)annotation).isAfterPosition()) {
            if (widgetOffset < textWidget.getCharCount()) {
                InlinedAnnotationDrawingStrategy.drawAsLeftOf1stCharacter(annotation, gc, textWidget, widgetOffset, length, color);
            } else {
                InlinedAnnotationDrawingStrategy.drawAtEndOfDocumentInFirstColumn(annotation, gc, textWidget, widgetOffset, length, color);
            }
            return;
        }
        if (annotation.isEmptyLine(widgetOffset, textWidget)) {
            InlinedAnnotationDrawingStrategy.drawAfterLine(annotation, gc, textWidget, widgetOffset, length, color);
        } else if (LineContentAnnotation.drawRightToPreviousChar(widgetOffset, textWidget)) {
            InlinedAnnotationDrawingStrategy.drawAsRightOfPreviousCharacter(annotation, gc, textWidget, widgetOffset, length, color);
        } else {
            InlinedAnnotationDrawingStrategy.drawAsLeftOf1stCharacter(annotation, gc, textWidget, widgetOffset, length, color);
        }
    }

    private static void drawAfterLine(LineContentAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation, textWidget.getCharCount())) {
            return;
        }
        if (gc != null) {
            if (textWidget.getCharCount() == 0) {
                annotation.draw(gc, textWidget, widgetOffset, length, color, 0, 0);
            } else {
                int line = textWidget.getLineAtOffset(widgetOffset);
                int lineEndOffset = line == textWidget.getLineCount() - 1 ? textWidget.getCharCount() - 1 : textWidget.getOffsetAtLine(line + 1) - 1;
                Rectangle bounds = textWidget.getTextBounds(lineEndOffset, lineEndOffset);
                int lineEndX = bounds.x + bounds.width + gc.stringExtent((String)"   ").x;
                annotation.setLocation(lineEndX, textWidget.getLinePixel(line) + textWidget.getLineVerticalIndent(line));
                annotation.draw(gc, textWidget, widgetOffset, length, color, lineEndX, textWidget.getLinePixel(line) + textWidget.getLineVerticalIndent(line));
            }
        } else {
            textWidget.redrawRange(widgetOffset, length, true);
        }
    }

    private static void drawAtEndOfDocumentInFirstColumn(LineContentAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation, textWidget.getCharCount())) {
            return;
        }
        if (gc != null) {
            Point locAtOff = textWidget.getLocationAtOffset(widgetOffset);
            int x = locAtOff.x;
            int y = locAtOff.y;
            annotation.setLocation(x, y);
            annotation.draw(gc, textWidget, widgetOffset, length, color, x, y);
            int width = annotation.getWidth();
            if (width != 0 && !gc.getClipping().contains(x, y)) {
                Rectangle client = textWidget.getClientArea();
                int height = textWidget.getLineHeight();
                textWidget.redraw(x, y, client.width, height, false);
            }
        } else {
            int charCount = textWidget.getCharCount();
            if (charCount > 0) {
                textWidget.redrawRange(charCount - 1, 1, true);
            } else {
                Rectangle client = textWidget.getClientArea();
                textWidget.redraw(0, 0, client.width, client.height, false);
            }
        }
    }

    protected static void drawAsLeftOf1stCharacter(LineContentAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        StyleRange style = null;
        try {
            style = textWidget.getStyleRangeAtOffset(widgetOffset);
        }
        catch (Exception e) {
            return;
        }
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation, textWidget.getCharCount())) {
            if (style != null && style.metrics != null) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
            return;
        }
        if (gc != null) {
            int verticalDrawingOffset;
            String hostCharacter = textWidget.getText(widgetOffset, widgetOffset);
            boolean isEndOfLine = "\r".equals(hostCharacter) || "\n".equals(hostCharacter);
            Rectangle bounds = textWidget.getTextBounds(widgetOffset, widgetOffset);
            int x = isEndOfLine ? textWidget.getLocationAtOffset((int)widgetOffset).x : bounds.x;
            int y = bounds.y;
            if (InlinedAnnotationDrawingStrategy.isAfterPosition(annotation)) {
                isEndOfLine = false;
            }
            if ((verticalDrawingOffset = bounds.height - textWidget.getLineHeight()) > 0) {
                y += verticalDrawingOffset;
            }
            annotation.setLocation(x, y);
            annotation.draw(gc, textWidget, widgetOffset, length, color, x, y);
            int width = annotation.getWidth();
            if (width != 0) {
                if (isEndOfLine) {
                    if (!gc.getClipping().contains(x, y)) {
                        Rectangle client = textWidget.getClientArea();
                        textWidget.redraw(x, y, client.width, bounds.height, false);
                    }
                } else {
                    String characterToBeDrawn;
                    ITextViewer iTextViewer;
                    Point charBounds = gc.stringExtent(hostCharacter);
                    int charWidth = charBounds.x;
                    if (charWidth == 0 && ("\r".equals(hostCharacter) || "\n".equals(hostCharacter))) {
                        charWidth = gc.stringExtent((String)" ").x;
                    }
                    annotation.setRedrawnCharacterWidth(charWidth);
                    FontMetrics fontMetrics = gc.getFontMetrics();
                    Object object = textWidget.getData();
                    if (object instanceof ITextViewer) {
                        ITextViewer viewer = (ITextViewer)object;
                        iTextViewer = viewer;
                    } else {
                        iTextViewer = annotation.getViewer();
                    }
                    StyleRange newStyle = annotation.updateStyle(style, fontMetrics, iTextViewer, InlinedAnnotationDrawingStrategy.isAfterPosition(annotation));
                    if (newStyle != null) {
                        textWidget.setStyleRange(newStyle);
                        return;
                    }
                    int redrawnHostCharX = x + bounds.width - charWidth;
                    int redrawnHostCharY = y;
                    gc.setForeground(textWidget.getForeground());
                    gc.setBackground(textWidget.getBackground());
                    gc.setFont(textWidget.getFont());
                    if (style != null) {
                        if (style.background != null) {
                            gc.setBackground(style.background);
                            gc.fillRectangle(redrawnHostCharX, redrawnHostCharY, charWidth + 1, bounds.height);
                        }
                        if (style.foreground != null) {
                            gc.setForeground(style.foreground);
                        }
                        if (style.font != null) {
                            gc.setFont(style.font);
                        }
                    }
                    if (textWidget.getSelection().x <= widgetOffset && textWidget.getSelection().y > widgetOffset) {
                        gc.setForeground(textWidget.getSelectionForeground());
                        gc.setBackground(textWidget.getSelectionBackground());
                    }
                    if ("\n".equals(characterToBeDrawn = hostCharacter)) {
                        characterToBeDrawn = "";
                    }
                    gc.drawString(characterToBeDrawn, redrawnHostCharX, redrawnHostCharY, true);
                }
            } else if (style != null && style.metrics != null && style.metrics.width != 0) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
        } else {
            textWidget.redrawRange(widgetOffset, length, true);
        }
    }

    private static boolean isAfterPosition(LineContentAnnotation annotation) {
        if (annotation instanceof CodeMiningLineContentAnnotation) {
            CodeMiningLineContentAnnotation a = (CodeMiningLineContentAnnotation)annotation;
            return a.isAfterPosition();
        }
        return false;
    }

    protected static void drawAsRightOfPreviousCharacter(LineContentAnnotation annotation, GC gc, StyledText textWidget, int widgetOffset, int length, Color color) {
        StyleRange style = null;
        try {
            style = textWidget.getStyleRangeAtOffset(widgetOffset - 1);
        }
        catch (Exception e) {
            return;
        }
        if (InlinedAnnotationDrawingStrategy.isDeleted(annotation, textWidget.getCharCount())) {
            if (style != null && style.metrics != null) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
            return;
        }
        if (gc != null) {
            char hostCharacter = textWidget.getText(widgetOffset - 1, widgetOffset - 1).charAt(0);
            int redrawnCharacterWidth = hostCharacter != '\t' ? gc.stringExtent((String)Character.toString((char)hostCharacter)).x : textWidget.getTabs() * gc.stringExtent((String)" ").x;
            Rectangle charBounds = textWidget.getTextBounds(widgetOffset - 1, widgetOffset - 1);
            Rectangle annotationBounds = new Rectangle(charBounds.x + redrawnCharacterWidth, charBounds.y, annotation.getWidth(), charBounds.height);
            int verticalDrawingOffset = charBounds.height - textWidget.getLineHeight();
            if (verticalDrawingOffset > 0) {
                annotationBounds.y += verticalDrawingOffset;
            }
            annotation.setLocation(annotationBounds.x, annotationBounds.y);
            annotation.draw(gc, textWidget, widgetOffset, length, color, annotationBounds.x, annotationBounds.y);
            int width = annotation.getWidth();
            if (width != 0) {
                String characterToBeDrawn;
                int toRedrawCharOffset;
                annotation.setRedrawnCharacterWidth(redrawnCharacterWidth);
                StyleRange newStyle = annotation.updateStyle(style, gc.getFontMetrics(), InlinedAnnotationSupport.getSupport(textWidget).getViewer(), InlinedAnnotationDrawingStrategy.isAfterPosition(annotation));
                if (newStyle != null) {
                    textWidget.setStyleRange(newStyle);
                    return;
                }
                gc.setForeground(textWidget.getForeground());
                gc.setBackground(textWidget.getBackground());
                gc.setFont(textWidget.getFont());
                if (style != null) {
                    if (style.background != null) {
                        gc.setBackground(style.background);
                        gc.fillRectangle(charBounds.x, annotationBounds.y, redrawnCharacterWidth, charBounds.height);
                    }
                    if (style.foreground != null) {
                        gc.setForeground(style.foreground);
                    }
                    if (style.font != null) {
                        gc.setFont(style.font);
                    }
                }
                if (textWidget.getSelection().x <= (toRedrawCharOffset = widgetOffset - 1) && textWidget.getSelection().y > toRedrawCharOffset) {
                    gc.setForeground(textWidget.getSelectionForeground());
                    gc.setBackground(textWidget.getSelectionBackground());
                }
                if ("\n".equals(characterToBeDrawn = Character.toString(hostCharacter))) {
                    characterToBeDrawn = "";
                }
                gc.drawString(characterToBeDrawn, charBounds.x, charBounds.y + verticalDrawingOffset, true);
            } else if (style != null && style.metrics != null && style.metrics.width != 0) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
        } else {
            textWidget.redrawRange(widgetOffset, length, true);
        }
    }

    private static boolean isDeleted(AbstractInlinedAnnotation annotation, int maxOffset) {
        if (annotation.isMarkedDeleted()) {
            return true;
        }
        Position pos = annotation.getPosition();
        if (pos.isDeleted()) {
            return true;
        }
        return pos.getLength() == 0 && pos.getOffset() < maxOffset;
    }

    private record GCConfig(Color foreground, Color background, Font font) {
        private static final GCConfig NO_CONFIG = new GCConfig(null, null, null);

        public static GCConfig fromGC(GC gc) {
            return gc != null ? new GCConfig(gc.getForeground(), gc.getBackground(), gc.getFont()) : NO_CONFIG;
        }

        public void applyTo(GC gc) {
            if (gc == null) {
                return;
            }
            if (this.foreground != null) {
                gc.setForeground(this.foreground);
            }
            if (this.background != null) {
                gc.setBackground(this.background);
            }
            if (this.font != null) {
                gc.setFont(this.font);
            }
        }
    }
}

