/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.win32.LITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLINK;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    int mouseDownIndex;
    long font;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final long LinkProc;
    static final TCHAR LinkClass;

    static {
        LinkClass = new TCHAR(0, "SysLink", true);
        if (OS.COMCTL32_MAJOR >= 6) {
            WNDCLASS wNDCLASS = new WNDCLASS();
            OS.GetClassInfo(0L, LinkClass, wNDCLASS);
            LinkProc = wNDCLASS.lpfnWndProc;
            long l = OS.GetModuleHandle(null);
            long l2 = OS.GetProcessHeap();
            wNDCLASS.hInstance = l;
            wNDCLASS.style &= 0xFFFFBFFF;
            wNDCLASS.style |= 8;
            int n = LinkClass.length() * TCHAR.sizeof;
            long l3 = OS.HeapAlloc(l2, 8, n);
            OS.MoveMemory(l3, LinkClass, n);
            wNDCLASS.lpszClassName = l3;
            OS.RegisterClass(wNDCLASS);
            OS.HeapFree(l2, 0, l3);
        } else {
            LinkProc = 0L;
        }
    }

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (LinkProc != 0L) {
            switch (n) {
                case 15: {
                    if (l2 == 0L) break;
                    OS.SendMessage(l, 792, l2, 0L);
                    return 0L;
                }
            }
            return OS.CallWindowProc(LinkProc, l, n, l2, l3);
        }
        return OS.DefWindowProc(l, n, l2, l3);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            long l = OS.GetDC(this.handle);
            long l2 = OS.SendMessage(this.handle, 49, 0L, 0L);
            long l3 = OS.SelectObject(l, l2);
            if (this.text.length() > 0) {
                TCHAR tCHAR = new TCHAR(this.getCodePage(), this.parse(this.text), false);
                RECT rECT = new RECT();
                int n5 = 3072;
                if (n != -1) {
                    n5 |= 0x10;
                    rECT.right = n;
                }
                OS.DrawText(l, tCHAR, tCHAR.length(), rECT, n5);
                n4 = rECT.right - rECT.left;
                n3 = rECT.bottom;
            } else {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(l, tEXTMETRIC);
                n4 = 0;
                n3 = tEXTMETRIC.tmHeight;
            }
            if (l2 != 0L) {
                OS.SelectObject(l, l3);
            }
            OS.ReleaseDC(this.handle, l);
        } else {
            int n6 = this.layout.getWidth();
            if (n == 0) {
                this.layout.setWidth(1);
                Rectangle rectangle = this.layout.getBounds();
                n4 = 0;
                n3 = rectangle.height;
            } else {
                this.layout.setWidth(n);
                Rectangle rectangle = this.layout.getBounds();
                n4 = rectangle.width;
                n3 = rectangle.height;
            }
            this.layout.setWidth(n6);
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        int n7 = this.getBorderWidth();
        return new Point(n4 += n7 * 2, n3 += n7 * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
        if (OS.COMCTL32_MAJOR < 6) {
            this.layout = new TextLayout(this.display);
            this.linkColor = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) ? Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_HOTLIGHT)) : new Color(this.display, LINK_FOREGROUND);
            this.disabledColor = Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            this.offsets = new Point[0];
            this.ids = new String[0];
            this.mnemonics = new int[0];
            this.selection = new Point(-1, -1);
            this.mouseDownIndex = -1;
            this.focusIndex = -1;
        }
    }

    void createWidget() {
        super.createWidget();
        this.text = "";
        if (OS.COMCTL32_MAJOR < 6) {
            if ((this.style & 0x8000000) != 0) {
                this.layout.setOrientation(0x4000000);
            }
            this.initAccessible();
        }
    }

    void drawWidget(GC gC, RECT rECT) {
        Rectangle[] rectangleArray;
        this.drawBackground(gC.handle, rECT);
        int n = this.selection.x;
        int n2 = this.selection.y;
        if (n > n2) {
            n = this.selection.y;
            n2 = this.selection.x;
        }
        n2 = -1;
        n = -1;
        if (!OS.IsWindowEnabled(this.handle)) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n, n2, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            rectangleArray = this.getRectangles(this.focusIndex);
            int n3 = 0;
            while (n3 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n3];
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n3;
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            rectangleArray = new Event();
            rectangleArray.gc = gC;
            rectangleArray.x = rECT.left;
            rectangleArray.y = rECT.top;
            rectangleArray.width = rECT.right - rECT.left;
            rectangleArray.height = rECT.bottom - rECT.top;
            this.sendEvent(9, (Event)rectangleArray);
            rectangleArray.gc = null;
        }
    }

    void enableWidget(boolean bl) {
        if (OS.COMCTL32_MAJOR >= 6) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 2;
            lITEM.state = bl ? 2 : 0;
            while (OS.SendMessage(this.handle, 1794, 0L, lITEM) != 0L) {
                ++lITEM.iLink;
            }
        } else {
            TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
            textStyle.underline = true;
            int n = 0;
            while (n < this.offsets.length) {
                Point point = this.offsets[n];
                this.layout.setStyle(textStyle, point.x, point.y);
                ++n;
            }
            this.redraw();
        }
        super.enableWidget(bl);
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Link.this.display.map((Control)Link.this.getParent(), null, Link.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = SWT.getMessage("SWT_Press");
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int n) {
        int n2 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n];
        int n3 = 1;
        while (point.x > nArray[n3]) {
            ++n3;
        }
        int n4 = 1;
        while (point.y > nArray[n4]) {
            ++n4;
        }
        int n5 = 0;
        if (n3 == n4) {
            rectangleArray[n5++] = this.layout.getBounds(point.x, point.y);
        } else {
            rectangleArray[n5++] = this.layout.getBounds(point.x, nArray[n3] - 1);
            rectangleArray[n5++] = this.layout.getBounds(nArray[n4 - 1], point.y);
            if (n4 - n3 > 1) {
                int n6 = n3;
                while (n6 < n4 - 1) {
                    rectangleArray[n5++] = this.layout.getLineBounds(n6);
                    ++n6;
                }
            }
        }
        if (rectangleArray.length != n5) {
            Rectangle[] rectangleArray2 = new Rectangle[n5];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n5);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n4 < n3) {
            n2 = Character.toLowerCase(cArray[n4]);
            block0 : switch (n5) {
                case 0: {
                    if (n2 != 60) break;
                    n8 = n4;
                    ++n5;
                    break;
                }
                case 1: {
                    if (n2 != 97) break;
                    ++n5;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n5 = 7;
                            break block0;
                        }
                        case 62: {
                            n9 = n4 + 1;
                            ++n5;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) break;
                    n5 = 13;
                    break;
                }
                case 3: {
                    if (n2 != 60) break;
                    n10 = n4;
                    ++n5;
                    break;
                }
                case 4: {
                    n5 = n2 == 47 ? n5 + 1 : 3;
                    break;
                }
                case 5: {
                    n5 = n2 == 97 ? n5 + 1 : 3;
                    break;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n6] = this.parseMnemonics(cArray, n7, n8, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n9, n10, stringBuffer);
                        this.offsets[n6] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n6] == null) {
                            this.ids[n6] = new String(cArray, n9, n10 - n9);
                        }
                        ++n6;
                        n10 = n11 = n4 + 1;
                        n9 = n11;
                        n8 = n11;
                        n7 = n11;
                        n5 = 0;
                        break;
                    }
                    n5 = 3;
                    break;
                }
                case 7: {
                    n5 = n2 == 114 ? n5 + 1 : 0;
                    break;
                }
                case 8: {
                    n5 = n2 == 101 ? n5 + 1 : 0;
                    break;
                }
                case 9: {
                    n5 = n2 == 102 ? n5 + 1 : 0;
                    break;
                }
                case 10: {
                    n5 = n2 == 61 ? n5 + 1 : 0;
                    break;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n5;
                        n11 = n4 + 1;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 12: {
                    if (n2 != 34) break;
                    this.ids[n6] = new String(cArray, n11, n4 - n11);
                    n5 = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n5 = 0;
                        break;
                    }
                    if (n2 != 61) break;
                    ++n5;
                    break;
                }
                case 14: {
                    n5 = n2 == 34 ? n5 + 1 : 0;
                    break;
                }
                case 15: {
                    if (n2 != 34) break;
                    n5 = 2;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            ++n4;
        }
        if (n7 < n3) {
            n2 = this.parseMnemonics(cArray, n7, n8, stringBuffer);
            n = this.parseMnemonics(cArray, Math.max(n8, n9), n3, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n6] = n;
        } else {
            this.mnemonics[n6] = -1;
        }
        if (this.offsets.length != n6) {
            Point[] pointArray = new Point[n6];
            System.arraycopy(this.offsets, 0, pointArray, 0, n6);
            this.offsets = pointArray;
            String[] stringArray = new String[n6];
            System.arraycopy(this.ids, 0, stringArray, 0, n6);
            this.ids = stringArray;
            int[] nArray = new int[n6 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n6 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            if (cArray[n4] == '&') {
                if (n4 + 1 < n2 && cArray[n4 + 1] == '&') {
                    stringBuffer.append(cArray[n4]);
                    ++n4;
                } else {
                    n3 = stringBuffer.length();
                }
            } else {
                stringBuffer.append(cArray[n4]);
            }
            ++n4;
        }
        return n3;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if (OS.COMCTL32_MAJOR >= 6) {
            boolean bl = OS.IsWindowEnabled(this.handle);
            if (string.length() == 0) {
                string = " ";
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
            this.parse(this.text);
            this.enableWidget(bl);
        } else {
            this.layout.setText(this.parse(this.text));
            this.focusIndex = this.offsets.length > 0 ? 0 : -1;
            this.selection.y = -1;
            this.selection.x = -1;
            int n = OS.GetWindowLong(this.handle, -16);
            n = this.offsets.length > 0 ? (n |= 0x10000) : (n &= 0xFFFEFFFF);
            OS.SetWindowLong(this.handle, -16, n);
            boolean bl = OS.IsWindowEnabled(this.handle);
            TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
            textStyle.underline = true;
            int n2 = 0;
            while (n2 < this.offsets.length) {
                Point point = this.offsets[n2];
                this.layout.setStyle(textStyle, point.x, point.y);
                ++n2;
            }
            TextStyle textStyle2 = new TextStyle(null, null, null);
            textStyle2.underline = true;
            int n3 = 0;
            while (n3 < this.mnemonics.length) {
                int n4 = this.mnemonics[n3];
                if (n4 != -1) {
                    this.layout.setStyle(textStyle2, n4, n4);
                }
                ++n3;
            }
            this.redraw();
        }
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        return n | 0x10000;
    }

    TCHAR windowClass() {
        return OS.COMCTL32_MAJOR >= 6 ? LinkClass : this.display.windowClass;
    }

    long windowProc() {
        return LinkProc != 0L ? LinkProc : this.display.windowProc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LRESULT WM_CHAR(long l, long l2) {
        LRESULT lRESULT = super.WM_CHAR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.focusIndex == -1) {
                return lRESULT;
            }
            switch ((int)l) {
                case 13: 
                case 32: {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendEvent(13, event);
                    return lRESULT;
                }
                case 9: {
                    boolean bl;
                    boolean bl2 = bl = OS.GetKeyState(16) >= 0;
                    if (bl) {
                        if (this.focusIndex >= this.offsets.length - 1) return lRESULT;
                        ++this.focusIndex;
                        this.redraw();
                        return lRESULT;
                    }
                    if (this.focusIndex <= 0) return lRESULT;
                    --this.focusIndex;
                    this.redraw();
                }
                default: {
                    return lRESULT;
                }
            }
        } else {
            switch ((int)l) {
                case 9: 
                case 13: 
                case 32: {
                    long l3 = this.callWindowProc(this.handle, 256, l, l2);
                    return new LRESULT(l3);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(long l, long l2) {
        boolean bl;
        int n;
        int n2;
        LRESULT lRESULT = super.WM_GETDLGCODE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        long l3 = 0L;
        if (OS.COMCTL32_MAJOR >= 6) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 1;
            n2 = 0;
            while (OS.SendMessage(this.handle, 1795, 0L, lITEM) != 0L) {
                if ((lITEM.state & 1) != 0) {
                    n2 = lITEM.iLink;
                }
                ++lITEM.iLink;
            }
            n = lITEM.iLink;
            l3 = this.callWindowProc(this.handle, 135, l, l2);
        } else {
            n2 = this.focusIndex;
            n = this.offsets.length;
        }
        if (n == 0) {
            return new LRESULT(l3 | 0x100L);
        }
        boolean bl2 = bl = OS.GetKeyState(16) >= 0;
        if (bl && n2 < n - 1) {
            return new LRESULT(l3 | 2L);
        }
        if (!bl && n2 > 0) {
            return new LRESULT(l3 | 2L);
        }
        return lRESULT;
    }

    LRESULT WM_GETFONT(long l, long l2) {
        LRESULT lRESULT = super.WM_GETFONT(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        long l3 = this.callWindowProc(this.handle, 49, l, l2);
        if (l3 != 0L) {
            return new LRESULT(l3);
        }
        if (this.font == 0L) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    LRESULT WM_KEYDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            switch ((int)l) {
                case 9: 
                case 13: 
                case 32: {
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(l, l2);
        if (OS.COMCTL32_MAJOR < 6) {
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int n = OS.GET_X_LPARAM(l2);
            int n2 = OS.GET_Y_LPARAM(l2);
            int n3 = this.layout.getOffset(n, n2, null);
            int n4 = this.selection.x;
            int n5 = this.selection.y;
            this.selection.x = n3;
            this.selection.y = -1;
            if (n4 != -1 && n5 != -1) {
                if (n4 > n5) {
                    int n6 = n4;
                    n4 = n5;
                    n5 = n6;
                }
                Rectangle rectangle = this.layout.getBounds(n4, n5);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            int n7 = 0;
            while (n7 < this.offsets.length) {
                Rectangle[] rectangleArray = this.getRectangles(n7);
                int n8 = 0;
                while (n8 < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n8];
                    if (rectangle.contains(n, n2)) {
                        if (n7 != this.focusIndex) {
                            this.redraw();
                        }
                        this.focusIndex = this.mouseDownIndex = n7;
                        return lRESULT;
                    }
                    ++n8;
                }
                ++n7;
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(long l, long l2) {
        LRESULT lRESULT = super.WM_LBUTTONUP(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.mouseDownIndex == -1) {
                return lRESULT;
            }
            int n = OS.GET_X_LPARAM(l2);
            int n2 = OS.GET_Y_LPARAM(l2);
            Rectangle[] rectangleArray = this.getRectangles(this.mouseDownIndex);
            int n3 = 0;
            while (n3 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n3];
                if (rectangle.contains(n, n2)) {
                    Event event = new Event();
                    event.text = this.ids[this.mouseDownIndex];
                    this.sendEvent(13, event);
                    break;
                }
                ++n3;
            }
        }
        this.mouseDownIndex = -1;
        return lRESULT;
    }

    LRESULT WM_NCHITTEST(long l, long l2) {
        LRESULT lRESULT = super.WM_NCHITTEST(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            return new LRESULT(1L);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(long l, long l2) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(l, l2);
        if (OS.COMCTL32_MAJOR < 6) {
            int n = OS.GET_X_LPARAM(l2);
            int n2 = OS.GET_Y_LPARAM(l2);
            if (OS.GetKeyState(1) < 0) {
                int n3 = this.selection.y;
                this.selection.y = this.layout.getOffset(n, n2, null);
                if (this.selection.y != n3) {
                    int n4 = this.selection.y;
                    if (n3 > n4) {
                        int n5 = n3;
                        n3 = n4;
                        n4 = n5;
                    }
                    Rectangle rectangle = this.layout.getBounds(n3, n4);
                    this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
            } else {
                int n6 = 0;
                while (n6 < this.offsets.length) {
                    Rectangle[] rectangleArray = this.getRectangles(n6);
                    int n7 = 0;
                    while (n7 < rectangleArray.length) {
                        Rectangle rectangle = rectangleArray[n7];
                        if (rectangle.contains(n, n2)) {
                            this.setCursor(this.display.getSystemCursor(21));
                            return lRESULT;
                        }
                        ++n7;
                    }
                    ++n6;
                }
                this.setCursor(null);
            }
        }
        return lRESULT;
    }

    LRESULT WM_PAINT(long l, long l2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            return super.WM_PAINT(l, l2);
        }
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = pAINTSTRUCT;
        gCData.hwnd = this.handle;
        GC gC = this.new_GC(gCData);
        if (gC != null) {
            int n = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n2 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n != 0 && n2 != 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawWidget(gC, rECT);
            }
            gC.dispose();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(long l, long l2) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(l, l2);
        if (OS.COMCTL32_MAJOR < 6) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            GCData gCData = new GCData();
            gCData.device = this.display;
            gCData.foreground = this.getForegroundPixel();
            GC gC = GC.win32_new(l, gCData);
            this.drawWidget(gC, rECT);
            gC.dispose();
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_SETFOCUS(l, l2);
        if (OS.COMCTL32_MAJOR < 6) {
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT WM_SETFONT(long l, long l2) {
        if (OS.COMCTL32_MAJOR < 6) {
            this.layout.setFont(Font.win32_new(this.display, l));
        }
        if (l2 != 0L) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.font = l;
        return super.WM_SETFONT(this.font, l2);
    }

    LRESULT WM_SIZE(long l, long l2) {
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if (OS.COMCTL32_MAJOR < 6) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.layout.setWidth(rECT.right > 0 ? rECT.right : -1);
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT wmColorChild(long l, long l2) {
        LRESULT lRESULT = super.wmColorChild(l, l2);
        if (OS.COMCTL32_MAJOR >= 6 && !OS.IsWindowEnabled(this.handle)) {
            OS.SetTextColor(l, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            if (lRESULT == null) {
                int n = this.getBackgroundPixel();
                OS.SetBkColor(l, n);
                long l3 = this.findBrush(n, 0);
                return new LRESULT(l3);
            }
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, long l, long l2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            switch (nMHDR.code) {
                case -4: 
                case -2: {
                    NMLINK nMLINK = new NMLINK();
                    OS.MoveMemory(nMLINK, l2, NMLINK.sizeof);
                    Event event = new Event();
                    event.text = this.ids[nMLINK.iLink];
                    this.sendEvent(13, event);
                }
            }
        }
        return super.wmNotifyChild(nMHDR, l, l2);
    }
}

