/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.MARGINS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.REBARBANDINFO;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TypedListener;

public class CoolItem
extends Item {
    CoolBar parent;
    Control control;
    int id;
    boolean ideal;
    boolean minimum;

    public CoolItem(CoolBar coolBar, int n) {
        super(coolBar, n);
        this.parent = coolBar;
        coolBar.createItem(this, coolBar.getItemCount());
    }

    public CoolItem(CoolBar coolBar, int n, int n2) {
        super(coolBar, n);
        this.parent = coolBar;
        coolBar.createItem(this, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2) {
        this.checkWidget();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return new Point(0, 0);
        }
        int n4 = n;
        int n5 = n2;
        if (n == -1) {
            n4 = 32;
        }
        if (n2 == -1) {
            n5 = 32;
        }
        if ((this.parent.style & 0x200) != 0) {
            n5 += this.parent.getMargin(n3);
        } else {
            n4 += this.parent.getMargin(n3);
        }
        return new Point(n4, n5);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(l, 1033, (long)n, rECT);
        if (OS.COMCTL32_MAJOR >= 6) {
            MARGINS mARGINS = new MARGINS();
            OS.SendMessage(l, 1064, 0L, mARGINS);
            rECT.left -= mARGINS.cxLeftWidth;
            rECT.right += mARGINS.cxRightWidth;
        }
        if (!this.parent.isLastItemOfRow(n)) {
            rECT.right = rECT.right + ((this.parent.style & 0x800000) == 0 ? 2 : 0);
        }
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        if ((this.parent.style & 0x200) != 0) {
            return new Rectangle(rECT.top, rECT.left, n3, n2);
        }
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    Rectangle getClientArea() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(l, 1058, (long)n, rECT);
        RECT rECT2 = new RECT();
        OS.SendMessage(l, 1033, (long)n, rECT2);
        int n2 = rECT2.left + rECT.left;
        int n3 = rECT2.top;
        int n4 = rECT2.right - rECT2.left - rECT.left;
        int n5 = rECT2.bottom - rECT2.top;
        if ((this.parent.style & 0x800000) == 0) {
            n3 += rECT.top;
            n4 -= rECT.right;
            n5 -= rECT.top + rECT.bottom;
        }
        if (n == 0) {
            REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
            rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
            rEBARBANDINFO.fMask = 2048;
            OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n, rEBARBANDINFO);
            n4 = n4 - rEBARBANDINFO.cxHeader + 1;
        }
        return new Rectangle(n2, n3, Math.max(0, n4), Math.max(0, n5));
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public CoolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
        this.control = null;
    }

    public void setControl(Control control) {
        int n;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        long l = this.parent.handle;
        long l2 = control3 != null ? control.topHandle() : 0L;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 16;
        rEBARBANDINFO.hwndChild = l2;
        this.control = control3;
        long l3 = 0L;
        if (control3 != null) {
            l3 = OS.GetWindow(l2, 3);
        }
        boolean bl = control3 != null && !control3.getVisible();
        boolean bl2 = control2 != null && control2.getVisible();
        OS.SendMessage(l, OS.RB_SETBANDINFO, (long)n, rEBARBANDINFO);
        if (bl) {
            control3.setVisible(false);
        }
        if (bl2) {
            control2.setVisible(true);
        }
        if (l3 != 0L && l3 != l2) {
            int n2 = 19;
            this.SetWindowPos(l2, l3, 0, 0, 0, 0, n2);
        }
    }

    public Point getPreferredSize() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Point(0, 0);
        }
        long l = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 544;
        OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n, rEBARBANDINFO);
        int n2 = rEBARBANDINFO.cxIdeal + this.parent.getMargin(n);
        if ((this.parent.style & 0x200) != 0) {
            return new Point(rEBARBANDINFO.cyMaxChild, n2);
        }
        return new Point(n2, rEBARBANDINFO.cyMaxChild);
    }

    public void setPreferredSize(int n, int n2) {
        int n3;
        int n4;
        this.checkWidget();
        int n5 = this.parent.indexOf(this);
        if (n5 == -1) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        this.ideal = true;
        long l = this.parent.handle;
        if ((this.parent.style & 0x200) != 0) {
            n4 = Math.max(0, n2 - this.parent.getMargin(n5));
            n3 = n;
        } else {
            n4 = Math.max(0, n - this.parent.getMargin(n5));
            n3 = n2;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n5, rEBARBANDINFO);
        rEBARBANDINFO.fMask = 544;
        rEBARBANDINFO.cxIdeal = n4;
        rEBARBANDINFO.cyMaxChild = n3;
        if (!this.minimum) {
            rEBARBANDINFO.cyMinChild = n3;
        }
        OS.SendMessage(l, OS.RB_SETBANDINFO, (long)n5, rEBARBANDINFO);
    }

    public void setPreferredSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setPreferredSize(point.x, point.y);
    }

    public Point getSize() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            new Point(0, 0);
        }
        long l = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(l, 1033, (long)n, rECT);
        if (OS.COMCTL32_MAJOR >= 6) {
            MARGINS mARGINS = new MARGINS();
            OS.SendMessage(l, 1064, 0L, mARGINS);
            rECT.left -= mARGINS.cxLeftWidth;
            rECT.right += mARGINS.cxRightWidth;
        }
        if (!this.parent.isLastItemOfRow(n)) {
            rECT.right = rECT.right + ((this.parent.style & 0x800000) == 0 ? 2 : 0);
        }
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        if ((this.parent.style & 0x200) != 0) {
            return new Point(n3, n2);
        }
        return new Point(n2, n3);
    }

    public void setSize(int n, int n2) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        int n6 = this.parent.indexOf(this);
        if (n6 == -1) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        long l = this.parent.handle;
        if ((this.parent.style & 0x200) != 0) {
            n5 = n2;
            n4 = n;
            n3 = Math.max(0, n2 - this.parent.getMargin(n6));
        } else {
            n5 = n;
            n4 = n2;
            n3 = Math.max(0, n - this.parent.getMargin(n6));
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 544;
        OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n6, rEBARBANDINFO);
        if (!this.ideal) {
            rEBARBANDINFO.cxIdeal = n3;
        }
        if (!this.minimum) {
            rEBARBANDINFO.cyMinChild = n4;
        }
        rEBARBANDINFO.cyChild = n4;
        if (!this.parent.isLastItemOfRow(n6)) {
            if (OS.COMCTL32_MAJOR >= 6) {
                MARGINS mARGINS = new MARGINS();
                OS.SendMessage(l, 1064, 0L, mARGINS);
                n5 -= mARGINS.cxLeftWidth + mARGINS.cxRightWidth;
            }
            int n7 = (this.parent.style & 0x800000) == 0 ? 2 : 0;
            rEBARBANDINFO.cx = n5 - n7;
            rEBARBANDINFO.fMask |= 0x40;
        }
        OS.SendMessage(l, OS.RB_SETBANDINFO, (long)n6, rEBARBANDINFO);
    }

    public void setSize(Point point) {
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Point(0, 0);
        }
        long l = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n, rEBARBANDINFO);
        if ((this.parent.style & 0x200) != 0) {
            return new Point(rEBARBANDINFO.cyMinChild, rEBARBANDINFO.cxMinChild);
        }
        return new Point(rEBARBANDINFO.cxMinChild, rEBARBANDINFO.cyMinChild);
    }

    public void setMinimumSize(int n, int n2) {
        int n3;
        int n4;
        this.checkWidget();
        int n5 = this.parent.indexOf(this);
        if (n5 == -1) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        this.minimum = true;
        long l = this.parent.handle;
        if ((this.parent.style & 0x200) != 0) {
            n4 = n2;
            n3 = n;
        } else {
            n4 = n;
            n3 = n2;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n5, rEBARBANDINFO);
        rEBARBANDINFO.cxMinChild = n4;
        rEBARBANDINFO.cyMinChild = n3;
        OS.SendMessage(l, OS.RB_SETBANDINFO, (long)n5, rEBARBANDINFO);
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    boolean getWrap() {
        int n = this.parent.indexOf(this);
        long l = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n, rEBARBANDINFO);
        return (rEBARBANDINFO.fStyle & 1) != 0;
    }

    void setWrap(boolean bl) {
        int n = this.parent.indexOf(this);
        long l = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(l, OS.RB_GETBANDINFO, (long)n, rEBARBANDINFO);
        rEBARBANDINFO.fStyle = bl ? (rEBARBANDINFO.fStyle |= 1) : (rEBARBANDINFO.fStyle &= 0xFFFFFFFE);
        OS.SendMessage(l, OS.RB_SETBANDINFO, (long)n, rEBARBANDINFO);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }
}

