/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskRepositoryUtil {
    public static boolean isAddAutomaticallyDisabled(String repositoryUrl) {
        String[] templateUrls;
        String deletedTemplates = TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.templates.deleted");
        String[] stringArray = templateUrls = deletedTemplates.split("\\|");
        int n = templateUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String deletedUrl = stringArray[n2];
            if (deletedUrl.equalsIgnoreCase(repositoryUrl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void disableAddAutomatically(String repositoryUrl) {
        if (!TaskRepositoryUtil.isAddAutomaticallyDisabled(repositoryUrl) && TaskRepositoryUtil.isAddAutomatically(repositoryUrl)) {
            Object deletedTemplates = TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.templates.deleted");
            deletedTemplates = (String)deletedTemplates + "|" + repositoryUrl;
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.templates.deleted", (String)deletedTemplates);
            TasksUiPlugin.getDefault().savePluginPreferences();
        }
    }

    public static boolean isAddAutomatically(String repositoryUrl) {
        for (AbstractRepositoryConnector connector : TasksUi.getRepositoryManager().getRepositoryConnectors()) {
            for (RepositoryTemplate template : TasksUiPlugin.getRepositoryTemplateManager().getTemplates(connector.getConnectorKind())) {
                if (template.repositoryUrl == null || !template.repositoryUrl.equalsIgnoreCase(repositoryUrl) || !template.addAutomatically) continue;
                return true;
            }
        }
        return false;
    }
}

