/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XmlExternalizationTest
extends TestCase {
    public void testWriteandReadBadCharacterXml10() throws Exception {
        System.err.println("= XML 1.0 =");
        int i = 0;
        while (i < 65535) {
            char badChar = (char)i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler handler = transformerFactory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("version", "1.0");
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            handler.setResult(new StreamResult(out));
            SimpleCharacterWriter writer = new SimpleCharacterWriter(handler);
            writer.write(badChar);
            XMLReader parser = CoreUtil.newXmlReader();
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            SimpleCharacterReader readHandler = new SimpleCharacterReader();
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    System.err.println(exception.getMessage());
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    System.err.println(exception.getMessage());
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    System.err.println(exception.getMessage());
                }
            });
            parser.setContentHandler(readHandler);
            parser.parse(new InputSource(new ByteArrayInputStream(out.toByteArray())));
            char character = readHandler.getCharacter();
            XmlExternalizationTest.assertEquals((char)badChar, (char)character);
            ++i;
        }
    }

    public void testWriteandReadBadCharacterXml11() throws Exception {
        System.err.println("= XML 1.1 =");
        int i = 0;
        while (i < 65535) {
            char badChar = (char)i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler handler = transformerFactory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("version", "1.1");
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            handler.setResult(new StreamResult(out));
            SimpleCharacterWriter writer = new SimpleCharacterWriter(handler);
            writer.write(badChar);
            XMLReader parser = CoreUtil.newXmlReader();
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            SimpleCharacterReader readHandler = new SimpleCharacterReader();
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    System.err.println(exception.getMessage());
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    System.err.println(exception.getMessage());
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    System.err.println(exception.getMessage());
                }
            });
            parser.setContentHandler(readHandler);
            parser.parse(new InputSource(new ByteArrayInputStream(out.toByteArray())));
            char character = readHandler.getCharacter();
            XmlExternalizationTest.assertEquals((char)badChar, (char)character);
            ++i;
        }
    }

    private static class SimpleCharacterReader
    extends DefaultHandler {
        private char ch;

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            XmlExternalizationTest.assertEquals((int)1, (int)length);
            this.ch = ch[start];
        }

        public char getCharacter() {
            return this.ch;
        }
    }

    private static final class SimpleCharacterWriter {
        private final TransformerHandler handler;

        public SimpleCharacterWriter(TransformerHandler handler) {
            this.handler = handler;
        }

        public void write(char character) throws SAXException {
            this.handler.startDocument();
            AttributesImpl atts = new AttributesImpl();
            this.handler.startElement("", "", "value", atts);
            this.handler.characters(new char[]{character}, 0, 1);
            this.handler.endElement("", "", "value");
            this.handler.endDocument();
        }
    }
}

