/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;

public class TaskListUnmatchedContainerTest
extends TestCase {
    private TaskList taskList;
    private UnmatchedTaskContainer unmatchedContainer;

    protected void setUp() throws Exception {
        this.taskList = new TaskList();
        this.unmatchedContainer = new UnmatchedTaskContainer("mock", "http://mockrepository.test");
        this.taskList.addUnmatchedContainer(this.unmatchedContainer);
    }

    protected void tearDown() throws Exception {
    }

    public void testRemoveLocalTask() {
        TaskCategory category = new TaskCategory("taskCategoryHandle");
        this.taskList.addCategory(category);
        LocalTask newTask = new LocalTask("" + this.taskList.getNextLocalTaskId(), "new local task");
        this.taskList.addTask((ITask)newTask, (AbstractTaskContainer)category);
        TaskListUnmatchedContainerTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        this.taskList.removeFromContainer((AbstractTaskContainer)category, (ITask)newTask);
        TaskListUnmatchedContainerTest.assertFalse((boolean)category.contains(newTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getDefaultCategory().contains(newTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertEquals((int)1, (int)newTask.getParentContainers().size());
        TaskListUnmatchedContainerTest.assertEquals((Object)this.taskList.getDefaultCategory(), (Object)TaskCategory.getParentTaskCategory((ITask)newTask));
    }

    public void testLocalTaskOrphanedInDeletedTaskCategory() {
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getDefaultCategory().isEmpty());
        TaskCategory category = new TaskCategory("taskCategoryHandle");
        this.taskList.addCategory(category);
        LocalTask newTask = new LocalTask("" + this.taskList.getNextLocalTaskId(), "new local task");
        this.taskList.addTask((ITask)newTask, (AbstractTaskContainer)category);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getDefaultCategory().isEmpty());
        this.taskList.deleteCategory((AbstractTaskCategory)category);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getDefaultCategory().contains(newTask.getHandleIdentifier()));
    }

    public void testTaskRemovedFromQuery() {
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        this.taskList.removeFromContainer((AbstractTaskContainer)mockQuery, (ITask)mockTask);
        TaskListUnmatchedContainerTest.assertFalse((boolean)mockQuery.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
    }

    public void testTaskRemovedFromQueryButInCategory() {
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        TaskCategory category = new TaskCategory("taskCategoryHandle");
        this.taskList.addCategory(category);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)category);
        TaskListUnmatchedContainerTest.assertTrue((boolean)category.contains(mockTask.getHandleIdentifier()));
        this.taskList.removeFromContainer((AbstractTaskContainer)mockQuery, (ITask)mockTask);
        TaskListUnmatchedContainerTest.assertFalse((boolean)mockQuery.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        TaskListUnmatchedContainerTest.assertTrue((boolean)category.contains(mockTask.getHandleIdentifier()));
        this.taskList.removeFromContainer((AbstractTaskContainer)category, (ITask)mockTask);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
    }

    public void testRepositoryTaskInDeletedCategory() {
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        TaskListUnmatchedContainerTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskCategory category = new TaskCategory("taskCategoryHandle");
        this.taskList.addCategory(category);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)category);
        TaskListUnmatchedContainerTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getDefaultCategory().isEmpty());
        this.taskList.deleteCategory((AbstractTaskCategory)category);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.isEmpty());
        TaskListUnmatchedContainerTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
    }

    public void testRepositoryTaskInDeletedQuery() {
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        TaskListUnmatchedContainerTest.assertTrue((this.taskList.getQueries().size() > 0 ? 1 : 0) != 0);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        TaskListUnmatchedContainerTest.assertTrue((boolean)mockQuery.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.isEmpty());
        this.taskList.deleteQuery((RepositoryQuery)mockQuery);
        TaskListUnmatchedContainerTest.assertTrue((this.taskList.getQueries().size() == 0 ? 1 : 0) != 0);
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.unmatchedContainer.isEmpty());
    }

    public void testRemovalOfTaskInTwoQueries() {
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query 1");
        MockRepositoryQuery mockQuery2 = new MockRepositoryQuery("mock query 2");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addQuery((RepositoryQuery)mockQuery2);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery2);
        this.taskList.removeFromContainer((AbstractTaskContainer)mockQuery2, (ITask)mockTask);
        TaskListUnmatchedContainerTest.assertTrue((boolean)mockQuery2.isEmpty());
        TaskListUnmatchedContainerTest.assertFalse((boolean)mockQuery.isEmpty());
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.isEmpty());
    }

    public void testMoveLocalTask() {
        TaskCategory category = new TaskCategory("taskCategoryHandle");
        this.taskList.addCategory(category);
        LocalTask newTask = new LocalTask("" + this.taskList.getNextLocalTaskId(), "new local task");
        this.taskList.addTask((ITask)newTask, null);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getDefaultCategory().contains(newTask.getHandleIdentifier()));
        this.taskList.addTask((ITask)newTask, (AbstractTaskContainer)category);
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.taskList.getDefaultCategory().contains(newTask.getHandleIdentifier()));
    }

    public void testAddRepositoryTask() {
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        Set tasks = this.taskList.getTasks("http://mockrepository.test");
        TaskListUnmatchedContainerTest.assertFalse((boolean)tasks.isEmpty());
        RepositoryQuery query = (RepositoryQuery)mockTask.getParentContainers().iterator().next();
        TaskListUnmatchedContainerTest.assertEquals((Object)((Object)mockQuery), (Object)query);
        TaskListUnmatchedContainerTest.assertFalse((boolean)query.isEmpty());
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.isEmpty());
    }

    public void testMoveRepositoryTask() {
        TaskList tasklist = this.taskList;
        TaskListUnmatchedContainerTest.assertTrue((boolean)tasklist.getAllTasks().isEmpty());
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        TaskCategory category = new TaskCategory("taskCategoryHandle");
        this.taskList.addCategory(category);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)category);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getDefaultCategory().isEmpty());
        TaskListUnmatchedContainerTest.assertTrue((boolean)category.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)mockQuery.contains(mockTask.getHandleIdentifier()));
    }

    public void testRefactorOrphanedHandle() {
        MockTask mockTask = new MockTask("1");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        this.taskList.removeFromContainer((AbstractTaskContainer)mockQuery, (ITask)mockTask);
        TaskListUnmatchedContainerTest.assertFalse((boolean)mockQuery.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
        this.taskList.refactorRepositoryUrl("http://mockrepository.test", "http://mockrepository.testnew");
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.taskList.getUnmatchedContainer("http://mockrepository.testnew").contains(mockTask.getHandleIdentifier()));
    }

    public void testOrphanedSubtasks() {
        MockTask mockTask = new MockTask("1");
        MockTask mockTask2 = new MockTask("2");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        this.taskList.addTask((ITask)mockTask2, (AbstractTaskContainer)mockTask);
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.unmatchedContainer.contains(mockTask2.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertNotNull((Object)this.taskList.getTask(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertNotNull((Object)this.taskList.getTask(mockTask2.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertNotNull((Object)this.unmatchedContainer);
        this.taskList.removeFromContainer((AbstractTaskContainer)mockQuery, (ITask)mockTask);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)mockTask.contains(mockTask2.getHandleIdentifier()));
        this.taskList.deleteTask((ITask)mockTask);
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.contains(mockTask2.getHandleIdentifier()));
    }

    public void testOrphanedSubtaskWithOtherParent() {
        MockTask mockTask = new MockTask("1");
        MockTask mockTask2 = new MockTask("2");
        MockTask mockTask3 = new MockTask("3");
        MockRepositoryQuery mockQuery = new MockRepositoryQuery("mock query");
        this.taskList.addQuery((RepositoryQuery)mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        this.taskList.addTask((ITask)mockTask2, (AbstractTaskContainer)mockTask);
        this.taskList.addTask((ITask)mockTask3, (AbstractTaskContainer)mockQuery);
        this.taskList.addTask((ITask)mockTask2, (AbstractTaskContainer)mockTask3);
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.unmatchedContainer.contains(mockTask2.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertFalse((boolean)this.unmatchedContainer.contains(mockTask3.getHandleIdentifier()));
        this.taskList.removeFromContainer((AbstractTaskContainer)mockQuery, (ITask)mockTask);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.contains(mockTask.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)mockTask.contains(mockTask2.getHandleIdentifier()));
        this.taskList.removeFromContainer((AbstractTaskContainer)mockQuery, (ITask)mockTask3);
        TaskListUnmatchedContainerTest.assertTrue((boolean)this.unmatchedContainer.contains(mockTask3.getHandleIdentifier()));
        TaskListUnmatchedContainerTest.assertTrue((boolean)mockTask3.contains(mockTask2.getHandleIdentifier()));
    }
}

