/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.eclipse.mylyn.internal.tasks.core.externalization.AttributesWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.ContentHandlerWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SaxOrphanWriter {
    private final ContentHandlerWrapper handler;

    public SaxOrphanWriter(ContentHandlerWrapper handler) {
        this.handler = handler;
    }

    public void writeOrphans(NodeList orphanNodes) throws SAXException {
        int i = 0;
        while (i < orphanNodes.getLength()) {
            Node orphanNode = orphanNodes.item(i);
            if (orphanNode instanceof Element) {
                Element orphanElement = (Element)orphanNode;
                AttributesWrapper saxAttributes = this.getAttributes(orphanElement);
                this.handler.startElement(orphanElement.getNodeName(), saxAttributes);
                this.writeOrphans(orphanElement.getChildNodes());
                this.handler.endElement(orphanElement.getNodeName());
            } else if (orphanNode instanceof Text) {
                Text orphanText = (Text)orphanNode;
                this.handler.characters(orphanText.getData());
            }
            ++i;
        }
    }

    private AttributesWrapper getAttributes(Element orphanElement) {
        AttributesWrapper saxAttributes = new AttributesWrapper();
        NamedNodeMap domAttributes = orphanElement.getAttributes();
        int i = 0;
        while (i < domAttributes.getLength()) {
            Node attribute = domAttributes.item(i);
            saxAttributes.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        return saxAttributes;
    }
}

