/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.editors.parts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.Messages;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskReview
implements IAdaptable {
    private final ITask review;

    public TaskReview(ITask review) {
        this.review = review;
    }

    public String getSummary() {
        return this.review.getSummary();
    }

    public int getCodeReviewScore() {
        String reviewScore = this.review.getAttribute(Messages.TaskEditorReviewsPart_CodeReviewAttribute);
        try {
            return Integer.parseInt(reviewScore);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getVerifiedScore() {
        String verifiedScore = this.review.getAttribute(Messages.TaskEditorReviewsPart_VerifiedAttribute);
        try {
            return Integer.parseInt(verifiedScore);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getUrl() {
        return this.review.getUrl();
    }

    public ITask.SynchronizationState getSyncState() {
        return this.review.getSynchronizationState();
    }

    public String getStatus() {
        return this.review.getAttribute("task.common.status");
    }

    public String getBranch() {
        return this.review.getAttribute("BRANCH");
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.review.getClass())) {
            return (T)this.review;
        }
        return null;
    }
}

