/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.impl.AbstractTransaction;
import com.google.gwtorm.jdbc.JdbcSchema;
import java.sql.SQLException;

class JdbcTransaction
extends AbstractTransaction {
    private final JdbcSchema schema;
    private boolean inProgress;
    private boolean committed;

    JdbcTransaction(JdbcSchema s) {
        this.schema = s;
    }

    @Override
    public void commit() throws OrmException {
        this.notCommitted();
        if (!this.inProgress) {
            try {
                this.schema.getConnection().setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new OrmException("Cannot start transaction", e);
            }
            this.inProgress = true;
        }
        try {
            super.commit();
        }
        catch (OrmException e) {
            try {
                this.rollback();
            }
            catch (OrmException e2) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.rollback();
            }
            catch (OrmException ormException) {
                // empty catch block
            }
            throw e;
        }
        try {
            this.schema.getConnection().commit();
            this.committed = true;
        }
        catch (SQLException e) {
            throw new OrmException("Transaction failed", e);
        }
        finally {
            this.exitTransaction();
        }
    }

    @Override
    public void rollback() throws OrmException {
        this.notCommitted();
        if (this.inProgress) {
            try {
                this.schema.getConnection().rollback();
            }
            catch (SQLException e) {
                throw new OrmException("Rollback failed", e);
            }
            finally {
                this.exitTransaction();
            }
        }
    }

    private void notCommitted() throws OrmException {
        if (this.committed) {
            throw new OrmException("Transaction already committed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitTransaction() {
        try {
            this.schema.getConnection().setAutoCommit(true);
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.inProgress = false;
        }
    }
}

