/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.Workbench;

public class MarkTaskHandlerTest
extends TestCase {
    private IHandlerService handlerService;
    private IWorkingSet workingSet;
    private IWorkingSetManager workingSetManager;

    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        TaskRepository repository = TaskTestUtil.createMockRepository();
        TasksUiPlugin.getRepositoryManager().addRepository(repository);
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(new HashSet(0));
        TaskTestUtil.openTasksViewInActivePerspective().clearFilters();
        this.workingSetManager = Workbench.getInstance().getWorkingSetManager();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        if (this.workingSet != null) {
            this.workingSetManager.removeWorkingSet(this.workingSet);
            this.workingSet = null;
        }
    }

    public void testMarkTaskCompleted() throws Exception {
        MockRepositoryConnector.getDefault().setHasLocalCompletionState(true);
        TaskTask task = TaskTestUtil.createMockTask("1");
        TaskTestUtil.addAndSelectTask((ITask)task);
        MarkTaskHandlerTest.assertFalse((boolean)task.isCompleted());
        this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
        MarkTaskHandlerTest.assertTrue((boolean)task.isCompleted());
        try {
            this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
            MarkTaskHandlerTest.fail((String)"Expected NotEnabledException");
        }
        catch (NotEnabledException notEnabledException) {
            // empty catch block
        }
    }

    public void testMarkLocalTaskCompleted() throws Exception {
        LocalTask localTask = new LocalTask("1", "");
        TaskTestUtil.addAndSelectTask((ITask)localTask);
        MarkTaskHandlerTest.assertFalse((boolean)localTask.isCompleted());
        this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
        MarkTaskHandlerTest.assertTrue((boolean)localTask.isCompleted());
        try {
            this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskComplete", null);
            MarkTaskHandlerTest.fail((String)"Expected NotEnabledException");
        }
        catch (NotEnabledException notEnabledException) {
            // empty catch block
        }
    }

    public void testMarkWorkingSetIncomingRead() throws Exception {
        this.workingSet = this.createAndSelectWorkingSet();
        TaskScheduleContentProvider.Incoming incoming = this.setScheduledPresentationAndSelectIncoming();
        TaskTask taskInWorkingSet = this.createIncomingTask("1", incoming, this.workingSet);
        TaskTask taskNotInWorkingSet = this.createIncomingTask("2", incoming, null);
        MarkTaskHandlerTest.assertTrue((boolean)this.workingSetContainsTask(taskInWorkingSet));
        MarkTaskHandlerTest.assertFalse((boolean)this.workingSetContainsTask(taskNotInWorkingSet));
        MarkTaskHandlerTest.assertTrue((boolean)taskInWorkingSet.getSynchronizationState().isIncoming());
        MarkTaskHandlerTest.assertTrue((boolean)taskNotInWorkingSet.getSynchronizationState().isIncoming());
        this.handlerService.executeCommand("org.eclipse.mylyn.tasks.ui.command.markTaskRead", null);
        MarkTaskHandlerTest.assertFalse((boolean)taskInWorkingSet.getSynchronizationState().isIncoming());
        MarkTaskHandlerTest.assertTrue((boolean)taskNotInWorkingSet.getSynchronizationState().isIncoming());
    }

    protected boolean workingSetContainsTask(TaskTask taskInWorkingSet) {
        List<IAdaptable> elements = Arrays.asList(this.workingSet.getElements());
        for (AbstractTaskContainer parent : taskInWorkingSet.getParentContainers()) {
            if (!elements.contains(parent)) continue;
            return true;
        }
        return false;
    }

    protected TaskScheduleContentProvider.Incoming setScheduledPresentationAndSelectIncoming() throws Exception {
        TaskListView taskListView = TaskTestUtil.openTasksViewInActivePerspective();
        for (AbstractTaskListPresentation presentation : TaskListView.getPresentations()) {
            if (!presentation.getId().equals("org.eclipse.mylyn.tasks.ui.scheduled")) continue;
            taskListView.applyPresentation(presentation);
            break;
        }
        taskListView.setFocusedMode(true);
        taskListView.refresh();
        MarkTaskHandlerTest.assertTrue((boolean)taskListView.getCurrentPresentation().getId().equals("org.eclipse.mylyn.tasks.ui.scheduled"));
        IContentProvider contentProvider = taskListView.getViewer().getContentProvider();
        MarkTaskHandlerTest.assertTrue((boolean)(contentProvider instanceof ITreeContentProvider));
        Object[] objectArray = ((ITreeContentProvider)contentProvider).getElements((Object)taskListView.getViewSite());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof TaskScheduleContentProvider.Incoming) {
                taskListView.getViewer().setSelection((ISelection)new StructuredSelection(element), true);
            }
            ++n2;
        }
        MarkTaskHandlerTest.assertEquals((int)taskListView.getSelectedTaskContainers().size(), (int)1);
        MarkTaskHandlerTest.assertTrue((boolean)(taskListView.getSelectedTaskContainers().get(0) instanceof TaskScheduleContentProvider.Incoming));
        return (TaskScheduleContentProvider.Incoming)taskListView.getSelectedTaskContainers().get(0);
    }

    protected TaskTask createIncomingTask(String id, TaskScheduleContentProvider.Incoming incoming, IWorkingSet workingSet) throws Exception {
        RepositoryQuery query = TaskTestUtil.createMockQuery("query." + id);
        TasksUiPlugin.getTaskList().addQuery(query);
        if (workingSet != null) {
            workingSet.setElements(new IAdaptable[]{query});
        }
        TaskTask task = TaskTestUtil.createMockTask(id);
        TasksUiPlugin.getTaskList().addTask((ITask)task, (AbstractTaskContainer)query);
        task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
        MarkTaskHandlerTest.assertTrue((boolean)incoming.getChildren().contains(task));
        return task;
    }

    protected IWorkingSet createAndSelectWorkingSet() {
        IWorkingSet workingSet = this.workingSetManager.createWorkingSet("Task Working Set", new IAdaptable[0]);
        workingSet.setId(TaskWorkingSetUpdater.ID_TASK_WORKING_SET);
        ArrayList<IWorkingSet> list = new ArrayList<IWorkingSet>();
        list.add(workingSet);
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(list);
        MarkTaskHandlerTest.assertTrue((boolean)TaskWorkingSetUpdater.isWorkingSetEnabled((IWorkingSet)workingSet));
        return workingSet;
    }
}

