/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootedReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.IReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundReentrantTypeResolver
extends AbstractList<IResolvedTypes>
implements IReentrantTypeResolver,
IResolvedTypes,
RandomAccess {
    private List<AbstractRootedReentrantTypeResolver> resolvers = Lists.newArrayList();
    private IResolvedTypes[] delegates;
    private boolean sealed = false;
    private int next;

    protected void addResolver(AbstractRootedReentrantTypeResolver resolver) {
        if (this.sealed) {
            throw new IllegalStateException();
        }
        this.resolvers.add(resolver);
    }

    @Override
    public void initializeFrom(EObject root) {
        throw new IllegalStateException();
    }

    @Override
    public IResolvedTypes reentrantResolve() {
        if (!this.sealed) {
            this.sealed = true;
            this.delegates = new IResolvedTypes[this.resolvers.size()];
        } else {
            ++this.next;
        }
        while (this.next < this.delegates.length) {
            int next = this.next;
            if (this.delegates[next] == null) {
                this.delegates[next] = this.resolvers.get(next).reentrantResolve();
            }
            ++this.next;
        }
        return this;
    }

    protected IResolvedTypes getDelegate(int idx) {
        if (!this.sealed) {
            this.reentrantResolve();
        }
        if (idx < this.delegates.length) {
            IResolvedTypes result = this.delegates[idx];
            if (result == null) {
                if (this.next != idx) {
                    this.delegates[idx] = this.resolvers.get(idx).reentrantResolve();
                    return this.delegates[idx];
                }
                return IResolvedTypes.NULL;
            }
            return result;
        }
        throw new IndexOutOfBoundsException("Index: " + idx + ", Size: " + this.delegates.length);
    }

    @Override
    public Collection<AbstractDiagnostic> getQueuedDiagnostics() {
        ArrayList result = Lists.newArrayList();
        for (IResolvedTypes delegate : this) {
            result.addAll(delegate.getQueuedDiagnostics());
        }
        return result;
    }

    @Override
    public boolean isRefinedType(XExpression expression) {
        IResolvedTypes delegate = this.getDelegate(expression);
        return delegate.isRefinedType(expression);
    }

    @Override
    public Collection<ILinkingCandidate> getFollowUpErrors() {
        ArrayList result = Lists.newArrayList();
        for (IResolvedTypes delegate : this) {
            result.addAll(delegate.getFollowUpErrors());
        }
        return result;
    }

    @Override
    public LightweightTypeReference getActualType(XExpression expression) {
        IResolvedTypes delegate = this.getDelegate(expression);
        return delegate.getActualType(expression);
    }

    protected IResolvedTypes getDelegate(XExpression expression) {
        int i = 0;
        while (i < this.resolvers.size()) {
            AbstractRootedReentrantTypeResolver resolver = this.resolvers.get(i);
            if (resolver.isHandled(expression)) {
                return this.getDelegate(i);
            }
            ++i;
        }
        return IResolvedTypes.NULL;
    }

    protected IResolvedTypes getDelegate(EObject object) {
        int i = 0;
        while (i < this.resolvers.size()) {
            AbstractRootedReentrantTypeResolver resolver = this.resolvers.get(i);
            if (resolver.isHandled(object)) {
                return this.getDelegate(i);
            }
            ++i;
        }
        return IResolvedTypes.NULL;
    }

    @Override
    public IExpressionScope getExpressionScope(EObject context, IExpressionScope.Anchor anchor) {
        IResolvedTypes delegate = this.getDelegate(context);
        return delegate.getExpressionScope(context, anchor);
    }

    @Override
    public boolean hasExpressionScope(EObject context, IExpressionScope.Anchor anchor) {
        IResolvedTypes delegate = this.getDelegate(context);
        return delegate.hasExpressionScope(context, anchor);
    }

    @Override
    public LightweightTypeReference getReturnType(XExpression expression) {
        IResolvedTypes delegate = this.getDelegate(expression);
        return delegate.getReturnType(expression);
    }

    @Override
    public LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
        int i = 0;
        while (i < this.resolvers.size()) {
            AbstractRootedReentrantTypeResolver resolver = this.resolvers.get(i);
            if (resolver.isHandled(identifiable)) {
                IResolvedTypes delegate = this.getDelegate(i);
                return delegate.getActualType(identifiable);
            }
            ++i;
        }
        return null;
    }

    @Override
    public LightweightTypeReference getExpectedType(XExpression expression) {
        IResolvedTypes delegate = this.getDelegate(expression);
        return delegate.getExpectedType(expression);
    }

    @Override
    public List<LightweightTypeReference> getThrownExceptions(XExpression obj) {
        IResolvedTypes delegate = this.getDelegate(obj);
        return delegate.getThrownExceptions(obj);
    }

    @Override
    public boolean isVoidTypeAllowed(XExpression expression) {
        IResolvedTypes delegate = this.getDelegate(expression);
        return delegate.isVoidTypeAllowed(expression);
    }

    @Override
    public LightweightTypeReference getExpectedReturnType(XExpression expression) {
        IResolvedTypes delegate = this.getDelegate(expression);
        return delegate.getExpectedReturnType(expression);
    }

    @Override
    public List<LightweightTypeReference> getActualTypeArguments(XExpression expression) {
        IResolvedTypes delegate = this.getDelegate(expression);
        return delegate.getActualTypeArguments(expression);
    }

    @Override
    public JvmIdentifiableElement getLinkedFeature(XAbstractFeatureCall featureCall) {
        if (featureCall == null) {
            return null;
        }
        IResolvedTypes delegate = this.getDelegate(featureCall);
        return delegate.getLinkedFeature(featureCall);
    }

    @Override
    public JvmIdentifiableElement getLinkedFeature(XConstructorCall constructorCall) {
        if (constructorCall == null) {
            return null;
        }
        IResolvedTypes delegate = this.getDelegate(constructorCall);
        return delegate.getLinkedFeature(constructorCall);
    }

    @Override
    public IFeatureLinkingCandidate getLinkingCandidate(XAbstractFeatureCall featureCall) {
        if (featureCall == null) {
            return null;
        }
        IResolvedTypes delegate = this.getDelegate(featureCall);
        return delegate.getLinkingCandidate(featureCall);
    }

    @Override
    public IConstructorLinkingCandidate getLinkingCandidate(XConstructorCall constructorCall) {
        if (constructorCall == null) {
            return null;
        }
        IResolvedTypes delegate = this.getDelegate(constructorCall);
        return delegate.getLinkingCandidate(constructorCall);
    }

    @Override
    public IResolvedTypes get(int index) {
        return this.getDelegate(index);
    }

    @Override
    public int size() {
        return this.resolvers.size();
    }
}

