/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.CompletionProposalComputer;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.XtextContentAssistProcessor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class RepeatedContentAssistProcessor
extends XtextContentAssistProcessor
implements ICompletionListener,
ICompletionListenerExtension {
    @Inject(optional=true)
    private IWorkbench workbench;
    private IContentAssistantExtension2 currentAssistant;

    public ModeAware getModeAwareProposalProvider() {
        return (ModeAware)((Object)super.getContentProposalProvider());
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ModeAware proposalProvider = this.getModeAwareProposalProvider();
        if (proposalProvider == null) {
            return new ICompletionProposal[0];
        }
        int i = 0;
        CompletionProposalComputer proposalComputer = this.createCompletionProposalComputer(viewer, offset);
        while (i++ < 1000) {
            ICompletionProposal[] result;
            proposalProvider.nextMode();
            if (this.currentAssistant != null) {
                this.currentAssistant.setStatusMessage(this.getStatusMessage());
            }
            if ((result = this.computeCompletionProposals((IXtextDocument)viewer.getDocument(), proposalComputer)) != null && result.length > 0) {
                return result;
            }
            if (!proposalProvider.isLastMode()) continue;
            return new ICompletionProposal[0];
        }
        throw new IllegalStateException("#isLastMode did not return true for 1000 times");
    }

    protected CompletionProposalComputer createCompletionProposalComputer(ITextViewer viewer, int offset) {
        return new CompletionProposalComputer(this, viewer, offset){
            ContentAssistContext[] previouslyComputed;

            protected ContentAssistContext[] createContentAssistContexts(XtextResource resource) {
                if (this.previouslyComputed != null) {
                    return this.previouslyComputed;
                }
                this.previouslyComputed = super.createContentAssistContexts(resource);
                return this.previouslyComputed;
            }
        };
    }

    protected ICompletionProposal[] computeCompletionProposals(IXtextDocument document, CompletionProposalComputer proposalComputer) {
        if (this.getContentProposalProvider() == null) {
            return null;
        }
        ICompletionProposal[] result = (ICompletionProposal[])document.priorityReadOnly(proposalComputer);
        Arrays.sort(result, this.getCompletionProposalComparator());
        result = this.getCompletionProposalPostProcessor().postProcess(result);
        return result;
    }

    protected String getStatusMessage() {
        String binding = "<binding>";
        if (this.workbench != null) {
            IBindingService bindingService = (IBindingService)this.workbench.getAdapter(IBindingService.class);
            binding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
        String category = this.getModeAwareProposalProvider().getNextCategory();
        return String.valueOf(binding) + " to show " + category;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        ModeAware proposalProvider = this.getModeAwareProposalProvider();
        if (proposalProvider != null) {
            proposalProvider.reset();
        }
        this.currentAssistant = (IContentAssistantExtension2)event.assistant;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        ModeAware proposalProvider = this.getModeAwareProposalProvider();
        if (proposalProvider != null) {
            proposalProvider.reset();
        }
        this.currentAssistant = null;
    }

    public void assistSessionRestarted(ContentAssistEvent event) {
        ModeAware proposalProvider = this.getModeAwareProposalProvider();
        if (proposalProvider != null) {
            proposalProvider.reset();
        }
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public static interface ModeAware {
        public void reset();

        public void nextMode();

        public boolean isLastMode();

        public String getNextCategory();
    }
}

