/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;

public class IndentationUtil {
    public static final Logger LOG = Logger.getLogger(IndentationUtil.class);
    private IDocument document;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    private String indentString;
    private String lineSeparator;

    public void initialize(IDocument document, URI resourceURI) {
        this.document = document;
        this.indentString = this.whitespaceInformationProvider.getIndentationInformation(resourceURI).getIndentString();
        this.lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(resourceURI).getLineSeparator();
    }

    public int getIndentationLevelAtOffset(int offset) {
        block4: {
            if (offset > 0) break block4;
            return 0;
        }
        try {
            int currentOffset = offset - 1;
            char currentChr = this.document.getChar(currentOffset);
            int indentationOffset = 0;
            while (currentChr != '\n' && currentChr != '\r' && currentOffset > 0) {
                indentationOffset = Character.isWhitespace(currentChr) ? ++indentationOffset : 0;
                currentChr = this.document.getChar(--currentOffset);
            }
            return indentationOffset / this.getIndentString().length();
        }
        catch (BadLocationException e) {
            LOG.error((Object)"Error calculating indentation at offset", (Throwable)e);
            return 0;
        }
    }

    public String indent(int level) {
        String indentString = this.getIndentString();
        StringBuilder indentBuilder = new StringBuilder();
        int i = 0;
        while (i < level) {
            indentBuilder.append(indentString);
            ++i;
        }
        return indentBuilder.toString();
    }

    public String getIndentString() {
        return this.indentString;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }
}

