/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.reconciler.Messages;
import org.eclipse.xtext.ui.editor.reconciler.ReconcilerReplaceRegion;
import org.eclipse.xtext.ui.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.ui.editor.reconciler.XtextDocumentReconcileStrategy;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XtextReconciler
extends Job
implements IReconciler {
    private static final Logger log = Logger.getLogger(XtextReconciler.class);
    private boolean isInstalled;
    private boolean shouldInstallCompletionListener;
    private volatile boolean paused;
    private ITextViewer textViewer;
    private TextInputListener textInputListener;
    private final DocumentListener documentListener;
    private int delay;
    private IReconcilingStrategy strategy;
    private boolean initalProcessDone;
    private LinkedBlockingQueue<DocumentEvent> pendingChanges = new LinkedBlockingQueue();

    @Inject
    public XtextReconciler(XtextDocumentReconcileStrategy strategy) {
        super(Messages.XtextReconciler_JobName);
        this.setPriority(20);
        this.setSystem(true);
        this.isInstalled = false;
        this.documentListener = new DocumentListener();
        this.paused = false;
        this.shouldInstallCompletionListener = false;
        this.setDelay(500);
        this.setReconcilingStrategy(strategy);
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.strategy;
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy) {
        this.strategy = strategy;
    }

    public void install(ITextViewer textViewer) {
        if (!this.isInstalled) {
            this.textViewer = textViewer;
            this.textInputListener = new TextInputListener();
            textViewer.addTextInputListener((ITextInputListener)this.textInputListener);
            this.handleInputDocumentChanged(null, textViewer.getDocument());
            if (textViewer instanceof ISourceViewerExtension4) {
                ContentAssistantFacade facade = ((ISourceViewerExtension4)textViewer).getContentAssistantFacade();
                if (facade == null) {
                    this.shouldInstallCompletionListener = true;
                } else {
                    facade.addCompletionListener((ICompletionListener)this.documentListener);
                }
                if (this.strategy instanceof ISourceViewerAware) {
                    ((ISourceViewerAware)this.strategy).setSourceViewer((ISourceViewer)textViewer);
                }
            }
            this.isInstalled = true;
        }
    }

    public void uninstall() {
        if (this.isInstalled) {
            this.textViewer.removeTextInputListener((ITextInputListener)this.textInputListener);
            this.isInstalled = false;
            if (this.documentListener != null) {
                if (this.textViewer instanceof ISourceViewerExtension4) {
                    ContentAssistantFacade facade = ((ISourceViewerExtension4)this.textViewer).getContentAssistantFacade();
                    facade.removeCompletionListener((ICompletionListener)this.documentListener);
                }
                if (this.textViewer.getDocument() instanceof IXtextDocument) {
                    ((IXtextDocument)this.textViewer.getDocument()).removeXtextDocumentContentObserver(this.documentListener);
                }
            }
        }
    }

    protected void handleInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.shouldInstallCompletionListener) {
            ContentAssistantFacade facade = ((ISourceViewerExtension4)this.textViewer).getContentAssistantFacade();
            if (facade != null) {
                facade.addCompletionListener((ICompletionListener)this.documentListener);
            }
            this.shouldInstallCompletionListener = false;
        }
        if (oldInput instanceof IXtextDocument) {
            ((IXtextDocument)oldInput).removeXtextDocumentContentObserver(this.documentListener);
        }
        if (newInput instanceof IXtextDocument) {
            ((IXtextDocument)newInput).addXtextDocumentContentObserver(this.documentListener);
            IXtextDocument document = XtextDocumentUtil.get(this.textViewer);
            this.strategy.setDocument((IDocument)document);
            if (!this.initalProcessDone && this.strategy instanceof IReconcilingStrategyExtension) {
                this.initalProcessDone = true;
                IReconcilingStrategyExtension reconcilingStrategyExtension = (IReconcilingStrategyExtension)this.strategy;
                reconcilingStrategyExtension.initialReconcile();
            }
        }
    }

    private void handleDocumentChanged(DocumentEvent event) {
        this.cancel();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Reconciler cancelled");
        }
        this.reallyEnqueueEvent(event);
        this.schedule(this.delay);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Reconciler scheduled with delay: " + this.delay));
        }
    }

    private void reallyEnqueueEvent(DocumentEvent event) {
        try {
            this.pendingChanges.put(event);
        }
        catch (InterruptedException e) {
            this.reallyEnqueueEvent(event);
        }
    }

    protected void pause() {
        this.paused = true;
    }

    protected void resume() {
        this.paused = false;
        this.schedule(this.delay);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean belongsTo(Object family) {
        return XtextReconciler.class.getName().equals(family);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        if (monitor.isCanceled() || this.paused) {
            return Status.CANCEL_STATUS;
        }
        long start = System.currentTimeMillis();
        IXtextDocument document = XtextDocumentUtil.get(this.textViewer);
        if (document instanceof XtextDocument) {
            ((XtextDocument)document).internalModify(new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    XtextReconciler.this.doRun(state, monitor);
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reconciliation finished. Time required: " + (System.currentTimeMillis() - start)));
        }
        return Status.OK_STATUS;
    }

    private ReconcilerReplaceRegion getMergedReplaceRegion(XtextResource resource) {
        ArrayList events = Lists.newArrayListWithExpectedSize((int)this.pendingChanges.size());
        this.pendingChanges.drainTo(events);
        if (events.isEmpty()) {
            return null;
        }
        IParseResult parseResult = resource.getParseResult();
        String resourceText = parseResult != null ? parseResult.getRootNode().getText() : "";
        ReconcilerReplaceRegion.Builder builder = ReconcilerReplaceRegion.builder(resourceText);
        for (DocumentEvent event : events) {
            builder.add(event.getOffset(), event.getLength(), event.getText());
        }
        ReconcilerReplaceRegion mergedRegion = builder.create();
        mergedRegion.setModificationStamp(((DocumentEvent)events.get(events.size() - 1)).getModificationStamp());
        return mergedRegion;
    }

    @Deprecated
    protected ReplaceRegion getAndResetReplaceRegion() {
        return null;
    }

    private void doRun(XtextResource state, @Nullable IProgressMonitor monitor) {
        ReconcilerReplaceRegion replaceRegionToBeProcessed;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        if ((replaceRegionToBeProcessed = this.getMergedReplaceRegion(state)) != null) {
            if (this.strategy instanceof IReconcilingStrategyExtension) {
                ((IReconcilingStrategyExtension)this.strategy).setProgressMonitor((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
            }
            if (this.strategy instanceof XtextDocumentReconcileStrategy) {
                ((XtextDocumentReconcileStrategy)this.strategy).setResource(state);
            }
            this.strategy.reconcile((IRegion)replaceRegionToBeProcessed);
        }
    }

    protected class DocumentListener
    implements IXtextDocumentContentObserver,
    ICompletionListener {
        private volatile boolean sessionStarted = false;

        protected DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (Display.getCurrent() == null) {
                log.error((Object)"Changes to the document must only be applied from the Display thread to keep them ordered", (Throwable)new Exception());
            }
            XtextReconciler.this.handleDocumentChanged(event);
        }

        public void performNecessaryUpdates(IXtextDocumentContentObserver.Processor processor) {
            try {
                if (!XtextReconciler.this.pendingChanges.isEmpty()) {
                    processor.process(new IUnitOfWork.Void<XtextResource>(){

                        public void process(XtextResource state) throws Exception {
                            XtextReconciler.this.doRun(state, null);
                        }
                    });
                }
            }
            catch (Exception exc) {
                log.error((Object)"Error while forcing reconciliation", (Throwable)exc);
            }
            if (this.sessionStarted && !XtextReconciler.this.paused) {
                XtextReconciler.this.pause();
            }
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            this.sessionStarted = true;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.sessionStarted = false;
            XtextReconciler.this.resume();
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }

    protected class TextInputListener
    implements ITextInputListener {
        protected TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            XtextReconciler.this.handleInputDocumentChanged(oldInput, newInput);
        }
    }
}

