/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.DocumentUtils;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtCodeReader;

public class QvtIndentAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String newLineDelimeter = QvtIndentAutoEditStrategy.getNewLineDelimeter(document, command);
        boolean customized = false;
        if (newLineDelimeter != null) {
            customized = this.smartAutoIndentAfterNewLine(document, command, newLineDelimeter);
        }
        if (!customized) {
            super.customizeDocumentCommand(document, command);
        }
    }

    private boolean smartAutoIndentAfterNewLine(IDocument document, DocumentCommand command, String newLineDelimeter) {
        if (!QvtIndentAutoEditStrategy.checkCommandOffset(document, command)) {
            return false;
        }
        try {
            IRegion info = DocumentUtils.getLineInformationOfOffset(document, command.offset);
            int currentLineStart = info.getOffset();
            String whiteSpace = DocumentUtils.getStartingWhiteSpace(document, currentLineStart, command.offset);
            String currentLineText = document.get(currentLineStart, info.getLength());
            String cmdText = String.valueOf(command.text) + whiteSpace;
            if (currentLineText.trim().endsWith("{")) {
                cmdText = String.valueOf(cmdText) + '\t';
                if (this.computeBraceBalance(document) > 0) {
                    command.caretOffset = command.offset + cmdText.length();
                    command.shiftsCaret = false;
                    command.text = cmdText = String.valueOf(cmdText) + newLineDelimeter + whiteSpace + "}";
                    return true;
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private int computeBraceBalance(IDocument document) throws IOException {
        int next;
        QvtCodeReader codeReader = new QvtCodeReader();
        codeReader.configureForwardReader(document, 0, document.getLength(), true, true);
        int balance = 0;
        while ((next = codeReader.read()) != -1) {
            char c = (char)next;
            if (c == '{') {
                ++balance;
                continue;
            }
            if (c != '}') continue;
            --balance;
        }
        return balance;
    }

    private static String getNewLineDelimeter(IDocument document, DocumentCommand command) {
        if (command.length != 0 || command.text == null) {
            return null;
        }
        String[] legalLineDelimiters = document.getLegalLineDelimiters();
        int i = TextUtilities.endsWith((String[])legalLineDelimiters, (String)command.text);
        return i != -1 ? legalLineDelimiters[i] : null;
    }

    private static boolean checkCommandOffset(IDocument document, DocumentCommand command) {
        return command.offset != -1 && document.getLength() != 0;
    }
}

